/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import weblogic.utils.collections.DelegatingIterator;

public class DelegatingCollection
implements Collection {
    private final Collection delegate;

    public DelegatingCollection(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.delegate = c;
    }

    public Collection getDelegate() {
        return this.delegate;
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.delegate.addAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public Iterator iterator() {
        return new DelegatingIterator(this.delegate.iterator());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public boolean add(Object o) {
        return this.delegate.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

