/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import weblogic.utils.collections.DelegatingCollection;
import weblogic.utils.collections.DelegatingSet;

public class DelegatingMap
implements Map {
    private final Map delegate;

    public DelegatingMap(Map m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.delegate = m;
    }

    public Map getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public Object get(Object key) {
        return this.getDelegate().get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    public Object put(Object key, Object value) {
        return this.getDelegate().put(key, value);
    }

    public void putAll(Map t) {
        this.getDelegate().putAll(t);
    }

    public Object remove(Object key) {
        return this.getDelegate().remove(key);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    public Set keySet() {
        return new DelegatingSet(this.getDelegate().keySet());
    }

    public Collection values() {
        return new DelegatingCollection(this.getDelegate().values());
    }

    public Set entrySet() {
        return new DelegatingSet(this.getDelegate().entrySet());
    }
}

