/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import weblogic.utils.collections.ArraySet;

public final class Iterators {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private Iterators() {
    }

    public static boolean addAll(Collection c, Iterator i) {
        boolean b = false;
        while (i.hasNext()) {
            b |= c.add(i.next());
        }
        return b;
    }

    public static boolean removeAll(Collection c, Iterator i) {
        boolean b = false;
        while (i.hasNext()) {
            b |= c.remove(i.next());
        }
        return b;
    }

    public static boolean retainAll(Collection c, Iterator i) {
        ArraySet s = new ArraySet();
        Iterators.addAll(s, i);
        return c.retainAll(s);
    }

    public static boolean containsAll(Collection c, Iterator i) {
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public static Object[] toArray(Iterator i) {
        ArrayList l = new ArrayList();
        Iterators.addAll(l, i);
        return l.toArray();
    }

    public static Object[] toArray(Iterator i, Object[] a) {
        ArrayList l = new ArrayList();
        Iterators.addAll(l, i);
        return l.toArray(a);
    }

    public static boolean equals(Iterator i1, Iterator i2) {
        while (i1.hasNext()) {
            Object o2;
            if (!i2.hasNext()) {
                return false;
            }
            Object o1 = i1.next();
            if (o1.equals(o2 = i2.next())) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public static boolean contains(Iterator i, Object o) {
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            return true;
        }
        return false;
    }
}

