/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class NumericKeyHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient Collection values;

    protected Entry createEntry(long key, Object value, Entry next) {
        return new Entry(key, value, next);
    }

    public NumericKeyHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public NumericKeyHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public NumericKeyHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        Entry[] tab = this.table;
        int index = (int)((key & Integer.MAX_VALUE) % (long)tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(long key) {
        Entry[] tab = this.table;
        int index = (int)((key & Integer.MAX_VALUE) % (long)tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (int)((e.key & Integer.MAX_VALUE) % (long)newCapacity);
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(long key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int index = (int)((key & Integer.MAX_VALUE) % (long)tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        tab[index] = this.createEntry(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(long key) {
        Entry[] tab = this.table;
        int index = (int)((key & Integer.MAX_VALUE) % (long)tab.length);
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        Object[] tab = this.table;
        Arrays.fill(tab, null);
        this.count = 0;
    }

    public Collection values() {
        Collection v = this.values;
        return v != null ? v : (this.values = new Values());
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public int size() {
            return NumericKeyHashMap.this.size();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                int pos;
                Entry current;
                Entry next;

                @Override
                public boolean hasNext() {
                    return this.setNext() != null;
                }

                public Object next() {
                    Entry ret = this.setNext();
                    this.next = null;
                    return ret.value;
                }

                private Entry setNext() {
                    if (this.next != null) {
                        return this.next;
                    }
                    while (this.current == null && this.pos < NumericKeyHashMap.this.table.length) {
                        this.current = NumericKeyHashMap.this.table[this.pos++];
                    }
                    this.next = this.current;
                    if (this.current != null) {
                        this.current = this.current.next;
                    }
                    return this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected static class Entry {
        final long key;
        Object value;
        Entry next;

        protected Entry(long key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

