/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import weblogic.utils.collections.MaybeMapper;
import weblogic.utils.collections.MaybeQueue;
import weblogic.utils.collections.TicketedArrayQueue;

public class PartialOrderSet<T>
implements MaybeQueue<T> {
    private final WindowedArrayQ<T>[] q;
    private final int pow;
    private final int q_length;
    private final int rspin;
    private final int wspin;
    private volatile long w = 0L;
    private volatile long r = 0L;
    private static final AtomicLongFieldUpdater<PartialOrderSet> wPos = AtomicLongFieldUpdater.newUpdater(PartialOrderSet.class, "w");
    private static final AtomicLongFieldUpdater<PartialOrderSet> rPos = AtomicLongFieldUpdater.newUpdater(PartialOrderSet.class, "r");

    public PartialOrderSet(int qlen) {
        this(qlen, 4);
    }

    public PartialOrderSet(int qlen, int lanes) {
        this(qlen, lanes, 3000, 3000);
    }

    public PartialOrderSet(int qlen, int lanes, int rspin, int wspin) {
        this.rspin = rspin;
        this.wspin = wspin;
        int pow = PartialOrderSet.log2(qlen, "qlen");
        lanes = PartialOrderSet.log2(lanes, "lanes");
        if (lanes > pow) {
            lanes = pow;
        }
        this.pow = pow >= lanes ? lanes : 0;
        qlen = 1 << pow - this.pow;
        this.q_length = 1 << pow;
        this.q = new WindowedArrayQ[1 << this.pow];
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i] = new WindowedArrayQ(qlen);
        }
    }

    private static int log2(int n, String name) {
        if (--n < 0 || (n <<= 1) < 0) {
            throw new IllegalArgumentException(name + " must be between 1 and 0x40000000");
        }
        int b = 16;
        int pow = 0;
        do {
            int p;
            if ((p = n >>> b) == 0) continue;
            pow += b;
            n = p;
        } while ((b >>>= 1) != 0);
        return pow;
    }

    private int indexOf(long pos) {
        return (int)(pos & (long)(this.q.length - 1));
    }

    private long genOf(long pos) {
        return pos >>> this.pow;
    }

    @Override
    public boolean add(T v) {
        if (!this.offer(v)) {
            throw new IllegalStateException("cannot add to a full PartialOrderSet");
        }
        return true;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        long diff = this.w - this.r;
        if (diff > Integer.MAX_VALUE) {
            diff = Integer.MAX_VALUE;
        }
        return this.drainTo(c, (int)diff);
    }

    @Override
    public int remainingCapacity() {
        long sz = this.r - this.w + (long)this.q_length;
        if (sz < 0L) {
            return 0;
        }
        if (sz > 0x7FFFFFFEL) {
            sz = 0x7FFFFFFEL;
        }
        return (int)sz;
    }

    @Override
    public int size() {
        long sz = this.w - this.r;
        if (sz < 0L) {
            return 0;
        }
        if (sz > 0x7FFFFFFEL) {
            sz = 0x7FFFFFFEL;
        }
        return (int)sz;
    }

    @Override
    public T element() {
        T v = this.peek();
        if (v == null) {
            throw new NoSuchElementException("expected PartialOrderSet to have at least one element");
        }
        return v;
    }

    @Override
    public T remove() {
        T v = this.poll();
        if (v == null) {
            throw new NoSuchElementException("expected PartialOrderSet to have at least one element");
        }
        return v;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T peek() {
        return this.peek(this.r);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(null, this.w);
    }

    @Override
    public <E> E[] toArray(E[] o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return this.toArray(o, this.w);
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("PartialOrderSet doesn't support remove at an arbitrary point");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("PartialOrderSet doesn't support remove at an arbitrary point");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("PartialOrderSet doesn't support remove at an arbitrary point");
    }

    @Override
    public boolean contains(Object v) {
        if (v == null) {
            throw new NullPointerException("PartialOrderSet doesn't store null values");
        }
        long wp = this.w;
        for (long rp = this.r; rp < wp; ++rp) {
            if (!v.equals(this.peek(rp))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean offer(T v, long timeout, TimeUnit tu) {
        throw new UnsupportedOperationException("PartialOrderSet doesn't support interruptible wait");
    }

    @Override
    public T poll(long timeout, TimeUnit tu) {
        throw new UnsupportedOperationException("PartialOrderSet doesn't support interruptible wait");
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        long wp;
        long rp;
        if (maxElements <= 0) {
            return 0;
        }
        if (c == this) {
            throw new IllegalArgumentException("Cannot drain PartialOrderSet to itself");
        }
        if (c == null) {
            throw new NullPointerException("c cannot be null");
        }
        do {
            if ((rp = this.r) >= (wp = this.w)) {
                return 0;
            }
            if (wp > rp + (long)maxElements) {
                wp = rp + (long)maxElements;
            }
            assert (this.w >= wp) : "dequeue from empty queue";
        } while (!rPos.compareAndSet(this, rp, wp));
        int j = (int)(wp - rp);
        assert (j > 0) : "expect at least one element will be copied";
        while (rp < wp) {
            c.add(this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), null, this.rspin));
            ++rp;
        }
        return j;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == this) {
            throw new IllegalArgumentException("Cannot addAll PartialOrderSet to itself");
        }
        int s = c.size();
        if (s == 0) {
            return false;
        }
        Iterator<T> it = c.iterator();
        do {
            long remainder = this.r + (long)this.q_length - this.w;
            assert (s >= 1) : "expect no less than 1 element to be copied";
            if (remainder <= 0L) {
                remainder = 1L;
            } else if (remainder > (long)s) {
                remainder = s;
            }
            assert (remainder <= (long)s) : "expect no more than c.size() stores being reserved";
            long wp = wPos.getAndAdd(this, remainder);
            s -= (int)remainder;
            while (remainder-- > 0L) {
                this.q[this.indexOf(wp)].enqueueNonInterruptibly(it.next(), this.genOf(wp), this.wspin);
                ++wp;
            }
        } while (s != 0);
        return true;
    }

    public int addNonBlocking(Collection<? extends T> c) {
        long remainder;
        long wp;
        if (c == this) {
            throw new IllegalArgumentException("Cannot addAll PartialOrderSet to itself");
        }
        int s = c.size();
        if (s == 0) {
            return 0;
        }
        do {
            if ((remainder = this.r + (long)this.q_length - (wp = this.w)) <= 0L) {
                return 0;
            }
            if (remainder > (long)s) {
                remainder = s;
            }
            assert (remainder <= (long)s) : "expect no more than c.size() stores being reserved";
        } while (!wPos.compareAndSet(this, wp, wp + remainder));
        s = (int)remainder;
        Iterator<T> it = c.iterator();
        while (remainder-- > 0L) {
            this.q[this.indexOf(wp)].enqueueNonInterruptibly(it.next(), this.genOf(wp), this.wspin);
            ++wp;
        }
        return s;
    }

    @Override
    public void clear() {
        long wp;
        long rp;
        do {
            if ((rp = this.r) >= (wp = this.w)) {
                return;
            }
            assert (this.w >= wp) : "dequeue from empty queue";
        } while (!rPos.compareAndSet(this, rp, wp));
        int i = this.indexOf(rp);
        int j = this.indexOf(wp);
        wp -= rp;
        if (j < i) {
            while (i < this.q.length) {
                this.q[i].dequeueNonInterruptibly(this.genOf(rp), null, this.rspin);
                ++i;
                ++rp;
            }
            i = 0;
        }
        while (i < j) {
            this.q[i].dequeueNonInterruptibly(this.genOf(rp), null, this.rspin);
            ++i;
            ++rp;
        }
    }

    private T peek(long rp) {
        while (rp < this.w) {
            int idx = this.indexOf(rp);
            long gen = this.genOf(rp);
            this.q[idx].readerS.awaitNonInterruptibly(gen);
            Object v = this.q[idx].get(gen);
            long rp1 = this.r;
            if (rp1 <= rp) {
                assert (v != null) : "expect no concurrent dequeues occurred, and all values in the queue are non-null";
                return v;
            }
            rp = rp1;
        }
        return null;
    }

    private Object[] toArray(Object[] o, long wp) {
        int i;
        Object[] ret;
        long rp = this.r;
        if (rp >= wp) {
            wp = rp;
        }
        int diff = (int)(wp - rp);
        Object[] objectArray = o == null ? new Object[diff] : (ret = o.length >= diff ? o : (Object[])Array.newInstance(o.getClass().getComponentType(), diff));
        if (ret.length == 0) {
            return ret;
        }
        Itr it = new Itr();
        for (i = 0; i < ret.length; ++i) {
            if (!it.hasNext()) {
                ret[i] = null;
                break;
            }
            ret[i] = it.next();
        }
        if (ret != o && i < ret.length) {
            o = (Object[])Array.newInstance(ret.getClass().getComponentType(), i);
            System.arraycopy(ret, 0, o, 0, i);
            ret = o;
        }
        return ret;
    }

    @Override
    public boolean offer(T v) {
        long wp;
        if (v == null) {
            throw new NullPointerException();
        }
        do {
            if ((wp = this.w) >= this.r + (long)this.q_length) {
                return false;
            }
            assert (wp - this.r < (long)this.q_length) : "enqueue exceeds queue size";
        } while (!wPos.compareAndSet(this, wp, wp + 1L));
        this.q[this.indexOf(wp)].enqueueNonInterruptibly(v, this.genOf(wp), this.wspin);
        return true;
    }

    @Override
    public void put(T v) throws InterruptedException {
        if (v == null) {
            throw new NullPointerException();
        }
        long wp = wPos.getAndIncrement(this);
        this.q[this.indexOf(wp)].enqueue(v, this.genOf(wp), this.wspin);
    }

    @Override
    public T take() throws InterruptedException {
        long rp = rPos.getAndIncrement(this);
        return this.q[this.indexOf(rp)].dequeue(this.genOf(rp), this.rspin);
    }

    @Override
    public T poll() {
        long rp;
        do {
            if ((rp = this.r) >= this.w) {
                return null;
            }
            assert (this.w - rp > 0L) : "dequeue from empty queue";
        } while (!rPos.compareAndSet(this, rp, rp + 1L));
        return this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), this.rspin);
    }

    public T putAndTake(T v) {
        long rp;
        if (this.r == this.w) {
            return v;
        }
        long wp = wPos.getAndIncrement(this);
        if (wp <= (rp = rPos.getAndIncrement(this))) {
            this.q[this.indexOf(wp)].enqueueNonInterruptibly(v, this.genOf(wp), this.wspin);
            return this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), this.rspin);
        }
        T r = this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), this.rspin);
        this.q[this.indexOf(wp)].enqueueNonInterruptibly(v, this.genOf(wp), this.wspin);
        return r;
    }

    @Override
    public boolean offerMaybe(T v, long maybeToken) {
        long wp;
        if (v == null) {
            throw new NullPointerException();
        }
        do {
            if ((wp = this.w) >= this.r + (long)this.q_length) {
                return false;
            }
            assert (wp - this.r < (long)this.q_length) : "enqueue exceeds queue size";
        } while (!wPos.compareAndSet(this, wp, wp + 1L));
        this.q[this.indexOf(wp)].enqueueNonInterruptibly(v, this.genOf(wp), maybeToken, this.wspin);
        return true;
    }

    @Override
    public void putMaybe(T v, long maybeToken) {
        if (v == null) {
            throw new NullPointerException();
        }
        long wp = wPos.getAndIncrement(this);
        this.q[this.indexOf(wp)].enqueueNonInterruptibly(v, this.genOf(wp), maybeToken, this.wspin);
    }

    @Override
    public T take(MaybeMapper<T> mu) throws InterruptedException {
        long rp;
        T v;
        while ((v = this.q[this.indexOf(rp = rPos.getAndIncrement(this))].dequeue(this.genOf(rp), mu, this.rspin)) == null) {
        }
        return v;
    }

    @Override
    public T poll(MaybeMapper<T> mu) {
        T v;
        long rp;
        do {
            if ((rp = this.r) >= this.w) {
                return null;
            }
            assert (this.w - rp > 0L) : "dequeue from empty queue";
        } while (!rPos.compareAndSet(this, rp, rp + 1L) || (v = this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), mu, this.rspin)) == null);
        return v;
    }

    public boolean offerMaybe(T v, long maybeToken, MaybeMapper<T> staleChecker, int retries) {
        do {
            if (!this.offerMaybe(v, maybeToken)) continue;
            return true;
        } while (--retries >= 0 && this.removeStaleFromHead(staleChecker));
        T result = staleChecker.unbox(v, maybeToken);
        return result == null;
    }

    boolean removeStaleFromHead(MaybeMapper<T> staleChecker) {
        long staleRemovedOrQueueChanged = 0L;
        long rp = this.r;
        while (true) {
            if (rp >= this.w) {
                return staleRemovedOrQueueChanged > 0L;
            }
            boolean isStale = this.q[this.indexOf(rp)].isStale(this.genOf(rp), staleChecker);
            if (!isStale) break;
            if (rPos.compareAndSet(this, rp, rp + 1L)) {
                T removed = this.q[this.indexOf(rp)].dequeueNonInterruptibly(this.genOf(rp), null, this.rspin);
                staleChecker.unbox(removed, Long.MIN_VALUE);
                ++rp;
                ++staleRemovedOrQueueChanged;
                continue;
            }
            rp = this.r;
            ++staleRemovedOrQueueChanged;
        }
        return staleRemovedOrQueueChanged > 0L;
    }

    private class Itr
    implements Iterator<T> {
        private long rp;
        private T v;

        Itr() {
            this.rp = PartialOrderSet.this.r;
            this.v = this.peek();
        }

        private T peek() {
            while (this.rp < PartialOrderSet.this.w) {
                int idx = PartialOrderSet.this.indexOf(this.rp);
                long gen = PartialOrderSet.this.genOf(this.rp);
                ((PartialOrderSet)PartialOrderSet.this).q[idx].readerS.awaitNonInterruptibly(gen);
                Object v = PartialOrderSet.this.q[idx].get(gen);
                long rp1 = PartialOrderSet.this.r;
                if (rp1 <= this.rp) {
                    ++this.rp;
                    assert (v != null) : "expect no concurrent dequeues occurred, and all values in the queue are non-null";
                    return v;
                }
                this.rp = rp1;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.v != null;
        }

        @Override
        public T next() {
            Object o = this.v;
            if (o == null) {
                throw new NoSuchElementException();
            }
            this.v = this.peek();
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("PartialOrderSet doesn't support remove at an arbitrary point");
        }
    }

    public static class WindowedArrayQ<T>
    extends TicketedArrayQueue<T> {
        long[] mt;

        public WindowedArrayQ(int plen) {
            super(plen);
            this.mt = new long[plen];
            for (int i = 0; i < plen; ++i) {
                this.mt[i] = -1L;
            }
        }

        public void enqueue(T v, long generation, int spin) throws InterruptedException {
            this.writerS.spinAwait(generation, spin);
            this.releaseReaders(generation, v);
        }

        public void enqueueNonInterruptibly(T v, long generation, int spin) {
            this.writerS.spinAwaitNonInterruptibly(generation, spin);
            this.releaseReaders(generation, v);
        }

        public void enqueueNonInterruptibly(T v, long generation, long maybeToken, int spin) {
            this.writerS.spinAwaitNonInterruptibly(generation, spin);
            int idx = this.indexFor(generation);
            this.mt[idx] = maybeToken;
            this.releaseReaders(generation, v);
        }

        public T dequeue(long generation, int spin) throws InterruptedException {
            this.readerS.spinAwait(generation, spin);
            return this.releaseWriters(generation);
        }

        public T dequeueNonInterruptibly(long generation, int spin) {
            this.readerS.spinAwaitNonInterruptibly(generation, spin);
            return this.releaseWriters(generation);
        }

        public T dequeue(long generation, MaybeMapper<T> mu, int spin) throws InterruptedException {
            this.readerS.spinAwait(generation, spin);
            int idx = this.indexFor(generation);
            long maybeToken = this.mt[idx];
            if (maybeToken >= 0L) {
                this.mt[idx] = -1L;
            }
            Object v = this.releaseWriters(generation);
            if (mu != null) {
                v = mu.unbox(v, maybeToken);
            }
            return v;
        }

        public T dequeueNonInterruptibly(long generation, MaybeMapper<T> mu, int spin) {
            this.readerS.spinAwaitNonInterruptibly(generation, spin);
            int idx = this.indexFor(generation);
            long maybeToken = this.mt[idx];
            if (maybeToken >= 0L) {
                this.mt[idx] = -1L;
            }
            Object v = this.releaseWriters(generation);
            if (mu != null) {
                v = mu.unbox(v, maybeToken);
            }
            return v;
        }

        public boolean isStale(long generation, MaybeMapper<T> staleChecker) {
            if (this.readerS.willBlock(generation)) {
                return false;
            }
            int idx = this.indexFor(generation);
            Object v = this.el.get(idx);
            if (v == null) {
                return true;
            }
            long maybeToken = this.mt[idx];
            return (v = staleChecker.unbox(v, maybeToken)) == null;
        }
    }
}

