/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class PartitionMatchMap<V> {
    public static final String WILDCARD = "_*_";
    private HashMap<PartitionMatchMapKey, V> matchMap;
    private boolean ignoreCase;
    private final transient ReentrantLock lock = new ReentrantLock();

    public PartitionMatchMap() {
        this(false);
    }

    public PartitionMatchMap(boolean ignoreURLCase) {
        this.matchMap = new HashMap();
        this.ignoreCase = ignoreURLCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(String hostname, int port, String uriPath, V value) {
        String normalizedHostname = PartitionMatchMap.normalizeHostname(hostname);
        int normalizedPort = PartitionMatchMap.normalizePort(port);
        String normalizedURIPath = this.normalizeURI(uriPath);
        if (normalizedHostname == null && normalizedPort == -1 && "/".equals(normalizedURIPath)) {
            return null;
        }
        PartitionMatchMapKey matchMapKey = new PartitionMatchMapKey(normalizedHostname, normalizedPort, normalizedURIPath);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            V entry = this.matchMap.get(matchMapKey);
            if (entry != null) {
                V oldValue;
                V v = oldValue = entry;
                return v;
            }
            HashMap snapshot = (HashMap)this.matchMap.clone();
            entry = snapshot.put(matchMapKey, value);
            this.matchMap = snapshot;
            V v = entry;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public V match(String hostname, int port, String uri) {
        int matchNumber;
        void var12_20;
        String normalizedHostname = PartitionMatchMap.normalizeHostname(hostname);
        int normalizedPort = PartitionMatchMap.normalizePort(port);
        String normalizedURIPath = this.normalizeURI(uri);
        HashMap filteredSubMap = new HashMap();
        HashMap exactSubMap = new HashMap();
        HashMap wildcardSubMap = new HashMap();
        boolean exactPortMatch = false;
        if (normalizedPort != -1) {
            for (PartitionMatchMapKey partitionMatchMapKey : this.matchMap.keySet()) {
                if (normalizedPort == partitionMatchMapKey.getPort()) {
                    exactSubMap.put(partitionMatchMapKey, this.matchMap.get(partitionMatchMapKey));
                    exactPortMatch = true;
                }
                if (partitionMatchMapKey.getPort() != -1) continue;
                wildcardSubMap.put(partitionMatchMapKey, this.matchMap.get(partitionMatchMapKey));
            }
            if (exactPortMatch) {
                if (exactSubMap.size() == 1) {
                    return exactSubMap.entrySet().iterator().next().getValue();
                }
                filteredSubMap = (HashMap)exactSubMap.clone();
            } else {
                filteredSubMap = (HashMap)wildcardSubMap.clone();
            }
        } else {
            for (PartitionMatchMapKey partitionMatchMapKey : this.matchMap.keySet()) {
                if (partitionMatchMapKey.getPort() != -1) continue;
                wildcardSubMap.put(partitionMatchMapKey, this.matchMap.get(partitionMatchMapKey));
            }
            filteredSubMap = (HashMap)wildcardSubMap.clone();
        }
        exactSubMap.clear();
        wildcardSubMap.clear();
        boolean exactHostnameMatch = false;
        if (normalizedHostname != null) {
            for (PartitionMatchMapKey key : filteredSubMap.keySet()) {
                if (normalizedHostname.equals(key.getHostname())) {
                    exactSubMap.put(key, filteredSubMap.get(key));
                    exactHostnameMatch = true;
                }
                if (key.getHostname() == null) {
                    wildcardSubMap.put(key, filteredSubMap.get(key));
                }
                if (!WILDCARD.equals(key.getHostname())) continue;
                exactSubMap.put(key, filteredSubMap.get(key));
                wildcardSubMap.put(key, filteredSubMap.get(key));
            }
            filteredSubMap = exactHostnameMatch ? (HashMap)exactSubMap.clone() : (HashMap)wildcardSubMap.clone();
        } else {
            for (PartitionMatchMapKey key : filteredSubMap.keySet()) {
                if (key.getHostname() != null && !WILDCARD.equals(key.getHostname())) continue;
                wildcardSubMap.put(key, filteredSubMap.get(key));
            }
            filteredSubMap = (HashMap)wildcardSubMap.clone();
        }
        exactSubMap.clear();
        wildcardSubMap.clear();
        String string = normalizedURIPath;
        boolean matchFound = false;
        while (var12_20 != null) {
            for (PartitionMatchMapKey key : filteredSubMap.keySet()) {
                if (!var12_20.equals(key.getPath())) continue;
                exactSubMap.put(key, filteredSubMap.get(key));
                matchFound = true;
            }
            if (matchFound) break;
            String string2 = PartitionMatchMap.shortenUrl((String)var12_20);
        }
        if ((matchNumber = exactSubMap.size()) == 0) {
            return null;
        }
        if (matchNumber == 1) {
            return exactSubMap.entrySet().iterator().next().getValue();
        }
        Object matchValue = exactSubMap.entrySet().iterator().next().getValue();
        boolean allValuesEqual = true;
        for (Object value : exactSubMap.values()) {
            if (value.equals(matchValue)) continue;
            allValuesEqual = false;
            break;
        }
        if (allValuesEqual) {
            return matchValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(String hostname, int port, String uri) {
        String normalizedHostname = PartitionMatchMap.normalizeHostname(hostname);
        int normalizedPort = PartitionMatchMap.normalizePort(port);
        String normalizedURIPath = this.normalizeURI(uri);
        PartitionMatchMapKey matchMapKey = new PartitionMatchMapKey(normalizedHostname, normalizedPort, normalizedURIPath);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            HashMap snapshot = (HashMap)this.matchMap.clone();
            Object entry = snapshot.remove(matchMapKey);
            this.matchMap = snapshot;
            Object v = entry;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean containsKey(String hostname, int port, String uri) {
        String normalizedHostname = PartitionMatchMap.normalizeHostname(hostname);
        int normalizedPort = PartitionMatchMap.normalizePort(port);
        String normalizedURIPath = this.normalizeURI(uri);
        PartitionMatchMapKey matchMapKey = new PartitionMatchMapKey(normalizedHostname, normalizedPort, normalizedURIPath);
        return this.matchMap.containsKey(matchMapKey);
    }

    private String normalizeURI(String url) {
        if (url == null) {
            return "/";
        }
        if ((url = url.trim()).isEmpty() || "/".equals(url)) {
            return "/";
        }
        String result = url;
        if (result.charAt(0) != '/') {
            result = "/" + url;
        }
        if (result.charAt(result.length() - 1) == '/') {
            result = result.substring(0, result.length() - 1);
        }
        return this.ignoreCase ? result.toUpperCase() : result;
    }

    private static String normalizeHostname(String hostname) {
        if (hostname == null) {
            return null;
        }
        if (hostname.isEmpty()) {
            return null;
        }
        return hostname.toUpperCase();
    }

    private static int normalizePort(int port) {
        if (port == 0 || port == -1) {
            return -1;
        }
        return port;
    }

    private static String shortenUrl(String url) {
        int i = url.lastIndexOf(47);
        int len = url.length();
        if (i > 0 && len > 1) {
            return url.substring(0, i);
        }
        if (i == 0 && len > 1) {
            return "/";
        }
        return null;
    }

    private class PartitionMatchMapKey {
        private final String hostname;
        private final int port;
        private final String path;

        public PartitionMatchMapKey(String hostname, int port, String path) {
            this.hostname = hostname;
            this.port = port;
            this.path = path;
        }

        String getHostname() {
            return this.hostname;
        }

        int getPort() {
            return this.port;
        }

        String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            PartitionMatchMapKey theOther = (PartitionMatchMapKey)o;
            return this.fieldEqual(this.hostname, theOther.hostname) && this.port == theOther.port && this.fieldEqual(this.path, theOther.path);
        }

        private boolean fieldEqual(String a, String b) {
            if (a == null && b == null) {
                return true;
            }
            if (a != null) {
                return a.equals(b);
            }
            return false;
        }

        public int hashCode() {
            String stringSum = this.hostname + this.path;
            return stringSum.length() + this.port;
        }
    }
}

