/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.utils.collections.CircularQueue;
import weblogic.utils.collections.ConcurrentHashMap;

public class SecondChanceCacheMap<K, V>
extends AbstractMap<K, V> {
    private final int capacity;
    private final ConcurrentHashMap<K, Entry<K, V>> map = new ConcurrentHashMap();
    private final CircularQueue<Entry<K, V>> list = new CircularQueue();
    private Set<Map.Entry<K, V>> entrySet;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public SecondChanceCacheMap(int size) {
        this.capacity = size;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Entry<K, V> e : this.map.values()) {
            V realA = e.getValue();
            if (!SecondChanceCacheMap.safeEquals(realA, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        Entry<K, V> e = this.map.get(key);
        if (e == null) {
            return null;
        }
        e.setSecondChance(true);
        return e.getValue();
    }

    @Override
    public synchronized V put(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        Entry<K, V> oldEntry = this.map.putIfAbsent(key, e);
        if (oldEntry != null) {
            V oldValue = oldEntry.getValue();
            oldEntry.setValue(value);
            return oldValue;
        }
        this.list.add(e);
        if (this.capacity < this.size()) {
            Entry<K, V> evictionEntry = this.getEntryForEviction();
            this.map.remove(evictionEntry.getKey());
            return evictionEntry.getValue();
        }
        return null;
    }

    public synchronized K insert(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        Entry<K, V> oldEntry = this.map.putIfAbsent(key, e);
        if (oldEntry != null) {
            oldEntry.setValue(value);
            return null;
        }
        this.list.add(e);
        if (this.capacity < this.size()) {
            Entry<K, V> evictionEntry = this.getEntryForEviction();
            K evictionKey = evictionEntry.getKey();
            this.map.remove(evictionKey);
            return evictionKey;
        }
        return null;
    }

    protected Entry<K, V> getEntryForEviction() {
        Entry<K, V> evictedEntry;
        while (true) {
            if (!(evictedEntry = this.list.remove()).getValid()) {
                continue;
            }
            if (!evictedEntry.getSecondChance()) break;
            evictedEntry.setSecondChance(false);
            this.list.add(evictedEntry);
        }
        return evictedEntry;
    }

    @Override
    public synchronized V remove(Object key) {
        Entry<K, V> old = this.map.remove(key);
        if (old == null) {
            return null;
        }
        old.setValid(false);
        if (this.list.size() > this.capacity) {
            this.cleanupInvalidObjects();
        }
        return old.getValue();
    }

    private void cleanupInvalidObjects() {
        int cacheSize = this.list.size();
        for (int i = 0; i < cacheSize; ++i) {
            Entry<K, V> entry = this.list.remove();
            if (!entry.getValid()) continue;
            this.list.add(entry);
        }
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        this.list.clear();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new SecondChanceIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    return SecondChanceCacheMap.this.map.get(entry.getKey()) != null;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object old = SecondChanceCacheMap.this.remove(entry.getKey());
                    return old != null;
                }

                @Override
                public int size() {
                    return SecondChanceCacheMap.this.size();
                }

                @Override
                public void clear() {
                    SecondChanceCacheMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private class SecondChanceIterator
    implements Iterator {
        Iterator<Entry<K, V>> mapIterator;
        final int type;

        public SecondChanceIterator(int type) {
            this.mapIterator = SecondChanceCacheMap.this.map.values().iterator();
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        public Object next() {
            Entry e = this.mapIterator.next();
            return this.type == 0 ? e.getKey() : (this.type == 1 ? e.getValue() : e);
        }

        @Override
        public void remove() {
            this.mapIterator.remove();
        }
    }

    protected static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;
        private boolean secondChance;
        private boolean valid;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
            this.secondChance = false;
            this.valid = true;
        }

        public boolean getSecondChance() {
            return this.secondChance;
        }

        public void setSecondChance(boolean b) {
            this.secondChance = b;
        }

        public boolean getValid() {
            return this.valid;
        }

        public void setValid(boolean b) {
            this.valid = b;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V o) {
            V old = this.value;
            this.value = o;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.toString() + " - key: " + this.key.toString() + " value: " + this.value.toString();
        }
    }
}

