/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;

public final class SlabPool
extends AbstractCollection
implements Pool {
    private final Pool slabs;
    private final int slabSize;
    private final ThreadLocal threadSlab = new ThreadLocal();

    public SlabPool(int num, int size) {
        this.slabs = new StackPool(num);
        this.slabSize = size;
    }

    @Override
    public int size() {
        Slab slab = (Slab)this.threadSlab.get();
        if (slab == null) {
            return 0;
        }
        return slab.pointer;
    }

    @Override
    public Iterator iterator() {
        Slab slab = (Slab)this.threadSlab.get();
        if (slab == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return new FilteringIterator(new ArrayIterator(slab.values)){

            @Override
            protected boolean accept(Object o) {
                return o != null;
            }
        };
    }

    @Override
    public boolean add(Object x) {
        Slab slab = (Slab)this.threadSlab.get();
        if (slab != null && slab.pointer == this.slabSize) {
            this.slabs.add(slab);
            slab = null;
        }
        if (slab == null) {
            slab = new Slab(this.slabSize);
            this.threadSlab.set(slab);
        }
        return slab.add(x);
    }

    public Object remove() {
        Slab slab = (Slab)this.threadSlab.get();
        if (slab == null) {
            slab = (Slab)this.slabs.remove();
        }
        if (slab == null) {
            return null;
        }
        return slab.remove();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static final class Slab {
        final int size;
        final Object[] values;
        int pointer;

        Slab(int s) {
            if (s < 0) {
                throw new IllegalArgumentException();
            }
            this.size = s;
            this.values = new Object[this.size];
            this.pointer = 0;
        }

        public boolean add(Object o) {
            if (this.pointer == this.size) {
                return false;
            }
            this.values[this.pointer++] = o;
            return true;
        }

        public Object remove() {
            if (this.pointer > 0) {
                Object o = this.values[--this.pointer];
                this.values[this.pointer] = null;
                return o;
            }
            return null;
        }
    }
}

