/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6634836669858888039L;
    private final transient Map<K, SoftValue<K, V>> hash;
    private final transient ReferenceQueue<V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet = null;

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, SoftValue<K, V>>(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this.hash = new HashMap<K, SoftValue<K, V>>(initialCapacity);
    }

    public SoftHashMap() {
        this.hash = new HashMap<K, SoftValue<K, V>>();
    }

    public SoftHashMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    @Override
    public Object clone() {
        try {
            SoftHashMap<K, V> m = new SoftHashMap<K, V>();
            m.putAll(this);
            return m;
        }
        catch (Exception ex) {
            return new SoftHashMap<K, V>(this);
        }
    }

    @Override
    public int size() {
        int j = 0;
        for (Map.Entry<K, SoftValue<K, V>> entry : this.hash.entrySet()) {
            SoftValue<K, V> ref = entry.getValue();
            if (ref != null && ref.get() == null) continue;
            ++j;
        }
        return j;
    }

    @Override
    public boolean isEmpty() {
        for (Map.Entry<K, SoftValue<K, V>> entry : this.hash.entrySet()) {
            SoftValue<K, V> ref = entry.getValue();
            if (ref != null && ref.get() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.hash.containsKey(key)) {
            return false;
        }
        SoftValue<K, V> ref = this.hash.get(key);
        return ref == null || ref.get() != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Object val = null;
        for (Map.Entry<K, SoftValue<K, V>> entry : this.hash.entrySet()) {
            SoftValue<K, V> ref = entry.getValue();
            if (value == null && ref == null) {
                return true;
            }
            if (ref != null) {
                Object t = ref.get();
                val = t;
                if (t == null) continue;
            }
            if (value == null || !val.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        SoftValue<K, V> ref = this.hash.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftValue o = this.hash.put(key, SoftValue.create(key, value, this.queue));
        if (o == null) {
            return null;
        }
        Object val = o.get();
        if (val != null) {
            o.clear();
        }
        return (V)val;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValue<K, V> ref = this.hash.remove(key);
        if (ref != null) {
            Object o = ref.get();
            if (o != null) {
                ref.clear();
            }
            return (V)o;
        }
        return null;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            Object key = sv.getKey();
            this.hash.remove(key);
            sv.resetKey();
            sv = null;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private static final class SoftValue<K, V>
    extends SoftReference<V> {
        private final int hash;
        private K key;

        private SoftValue(K key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
            this.hash = value.hashCode();
        }

        private static <K, V> SoftValue<K, V> create(K k, V v, ReferenceQueue<V> q) {
            if (v == null) {
                return null;
            }
            return new SoftValue<K, V>(k, v, q);
        }

        K getKey() {
            return this.key;
        }

        void resetKey() {
            this.key = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoftValue)) {
                return false;
            }
            Object t = this.get();
            Object u = ((SoftValue)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 151647111930348035L;
        final Set<Map.Entry<K, SoftValue<K, V>>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = SoftHashMap.this.hash.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                final Iterator<Map.Entry<K, SoftValue<K, V>>> hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        SoftValue ref = ent.getValue();
                        Object v = null;
                        if (ref != null) {
                            Object t = ref.get();
                            v = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, v);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    SoftHashMap.this.processQueue();
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            SoftHashMap.this.processQueue();
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SoftHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                Object key = ent.getKey();
                SoftValue ref = ent.getValue();
                Object v = ref.get();
                h += key.hashCode() ^ (v == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private final class Entry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, SoftValue<K, V>> ent;
        private V val;

        Entry(Map.Entry<K, SoftValue<K, V>> ent, V val) {
            this.ent = ent;
            this.val = val;
        }

        @Override
        public K getKey() {
            return this.ent.getKey();
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            this.val = value;
            return this.ent.setValue(SoftValue.create(this.getKey(), value, SoftHashMap.this.queue)).get();
        }

        private boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.valEquals(this.getKey(), e.getKey()) && this.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object v = this.getValue();
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }
}

