/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public class Turnstile {
    private volatile long nextTicket;
    private long incr;
    private volatile QNode head;
    private static final AtomicLongFieldUpdater<Turnstile> ticketUpdater = AtomicLongFieldUpdater.newUpdater(Turnstile.class, "nextTicket");
    private static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");
    private static final AtomicReferenceFieldUpdater<Turnstile, QNode> headUpdater = AtomicReferenceFieldUpdater.newUpdater(Turnstile.class, QNode.class, "head");

    public Turnstile(long nextTicket, long increment) {
        this.nextTicket = nextTicket;
        this.incr = increment;
        this.head = new QNode(null, nextTicket);
    }

    public Turnstile() {
        this(0L, 1L);
    }

    public long currentTicket() {
        return this.nextTicket;
    }

    public long advance() {
        return this.advance(this.incr);
    }

    public boolean advanceFrom(long t, long n) {
        long m = this.nextTicket;
        if (m >= n || m != t || !ticketUpdater.compareAndSet(this, t, n)) {
            return false;
        }
        this.release(n);
        return true;
    }

    public long advance(long incr) {
        long t = ticketUpdater.addAndGet(this, incr);
        this.release(t);
        return t;
    }

    public long advanceAlone() {
        long t = this.nextTicket;
        this.nextTicket = t += this.incr;
        this.release(t);
        return t;
    }

    public boolean willBlock(long myTicket) {
        long t = this.nextTicket;
        return myTicket > t;
    }

    private void awaitOn(long myTicket) throws InterruptedException {
        do {
            if (!this.willBlock(myTicket)) {
                this.release(myTicket);
                return;
            }
            LockSupport.park();
        } while (!Thread.currentThread().isInterrupted());
        throw new InterruptedException();
    }

    public void spinAwait(long myTicket, int spin) throws InterruptedException {
        if (!this.willBlock(myTicket)) {
            return;
        }
        for (int i = 0; i < spin; ++i) {
            if (this.willBlock(myTicket)) continue;
            return;
        }
        this.await(myTicket);
    }

    public void await(long myTicket) throws InterruptedException {
        if (!this.willBlock(myTicket)) {
            return;
        }
        QNode my = new QNode(Thread.currentThread(), myTicket);
        this.enqueue(my);
        this.awaitOn(myTicket);
    }

    public void spinAwaitNonInterruptibly(long myTicket, int spin) {
        if (!this.willBlock(myTicket)) {
            return;
        }
        for (int i = 0; i < spin; ++i) {
            if (this.willBlock(myTicket)) continue;
            return;
        }
        this.awaitNonInterruptibly(myTicket);
    }

    public void awaitNonInterruptibly(long myTicket) {
        if (!this.willBlock(myTicket)) {
            return;
        }
        QNode my = new QNode(Thread.currentThread(), myTicket);
        this.enqueue(my);
        try {
            this.awaitOn(myTicket);
        }
        catch (InterruptedException ie) {
            while (true) {
                try {
                    Thread.interrupted();
                    this.awaitOn(myTicket);
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private void enqueue(QNode my) {
        QNode n;
        long myTicket = my.ticket;
        QNode h = this.head;
        do {
            n = h.next;
            while (n != null && n.ticket < myTicket) {
                h = n;
                n = n.next;
            }
        } while (!this.link(h, n, my));
    }

    private boolean link(QNode prev, QNode expectedNext, QNode next) {
        next.next = expectedNext;
        return nextUpdater.compareAndSet(prev, expectedNext, next);
    }

    private boolean linkHead(QNode expectedHead, QNode newHead) {
        return headUpdater.compareAndSet(this, expectedHead, newHead);
    }

    private void release(long t) {
        QNode p;
        QNode h;
        do {
            p = h = this.head;
            QNode n = p.next;
            while (n != null && n.ticket <= t) {
                p = n;
                n = n.next;
            }
            if (p != h) continue;
            return;
        } while (!this.linkHead(h, p));
        while (h != p) {
            h = h.next;
            Thread w = h.waiter;
            h.waiter = null;
            assert (w != null) : "expect no one releases the same waiter concurrently";
            LockSupport.unpark(w);
        }
    }

    protected static class QNode {
        volatile QNode next;
        volatile Thread waiter;
        final long ticket;

        public QNode(Thread t, long ticket) {
            this.waiter = t;
            this.ticket = ticket;
        }
    }
}

