/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.lang.reflect.Method;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.ToolFailureException;

public abstract class Tool {
    private String name = this.getClass().getName();
    private String[] m_args;
    protected Getopt2 opts;
    private boolean requireExtraArgs;
    private boolean showStackTrace;
    public static final String START_SERVER_SIDE_STACK = "\nStart server side stack trace:\n";

    public Tool() {
        this(null);
    }

    public Tool(String[] args) {
        this.m_args = args;
        this.opts = new Getopt2();
        this.setShowStackTrace(true);
        this.opts.setFailOnUnrecognizedOpts(true);
        this.opts.addFlag("help", "Print the standard usage message.");
        this.opts.addFlag("version", "Print version information.");
        this.opts.addFlag("noexit", "Throw an exception instead of System.exit()ing.");
        this.opts.markPrivate("noexit");
    }

    public void setUsageName(String s) {
        this.name = s;
    }

    protected void exitWithError(Exception e, boolean advanced) throws Exception {
        String msg;
        if (this.opts.hasOption("noexit")) {
            throw e;
        }
        Throwable nested = e.getCause();
        String string = msg = nested == null ? e.getMessage() : nested.getMessage();
        if (e instanceof IllegalArgumentException) {
            this.opts.usageError(this.name, advanced);
        }
        if (msg != null) {
            if (!this.showStackTrace) {
                msg = this.stripStackTrace(msg);
            }
            System.err.println(msg);
        } else if (this.showStackTrace) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public String stripStackTrace(Throwable ex) {
        return this.stripStackTrace(ex.getMessage());
    }

    public String stripStackTrace(String exceptionMessage) {
        int indexOfTrace = exceptionMessage.indexOf(START_SERVER_SIDE_STACK);
        if (indexOfTrace != -1) {
            return exceptionMessage.substring(0, indexOfTrace);
        }
        return exceptionMessage;
    }

    public void setRequireExtraArgs(boolean flag) {
        this.requireExtraArgs = flag;
    }

    public boolean getRequireExtraArgs() {
        return this.requireExtraArgs;
    }

    public void setShowStackTrace(boolean flag) {
        this.showStackTrace = flag;
    }

    public boolean getShowStackTraace() {
        return this.showStackTrace;
    }

    public void run() throws Exception {
        this.run(this.m_args);
    }

    public void run(String[] args) throws Exception {
        try {
            this.prepare();
            if (this.opts.hasAdvancedOptions()) {
                this.opts.addFlag("advanced", "Print advanced usage options.");
            }
            this.opts.grok(this.transformArgs(args));
            if (this.opts.hasOption("version")) {
                try {
                    Class<?> versionClass = Class.forName("weblogic.version");
                    Method versionMethod = versionClass.getMethod("getBuildVersion", null);
                    Object version = versionMethod.invoke(null, (Object[])null);
                    System.out.println(this.name + " version " + version);
                }
                catch (Exception cnfe) {
                    System.out.println(this.name + " version unknown");
                }
                System.exit(0);
            }
            if (this.opts.hasOption("help")) {
                this.exitWithError(new IllegalArgumentException(""), false);
            }
            if (this.opts.hasOption("advanced")) {
                this.exitWithError(new IllegalArgumentException(""), true);
            }
            if (this.opts.args().length == 0 && this.requireExtraArgs) {
                if (this.opts.hasOptions()) {
                    this.exitWithError(new IllegalArgumentException("Only options were given, additional arguments are required."), false);
                } else {
                    this.exitWithError(new IllegalArgumentException("No arguments were given, there is nothing to do."), false);
                }
            }
            this.runBody();
            if (this.opts.hasOption("noexit")) {
                return;
            }
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            this.exitWithError(iae, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitWithError(e, false);
        }
    }

    public abstract void prepare() throws Exception;

    public abstract void runBody() throws Exception;

    protected String[] transformArgs(String[] args) throws ToolFailureException {
        return args;
    }
}

