/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.concurrent.atomic;

import weblogic.utils.concurrent.atomic.AtomicInteger;

public final class JavaAtomicInteger
implements AtomicInteger {
    private int value;

    JavaAtomicInteger() {
    }

    @Override
    public synchronized int addAndGet(int delta) {
        this.value += delta;
        return this.value;
    }

    @Override
    public synchronized int decrementAndGet() {
        return --this.value;
    }

    @Override
    public synchronized int get() {
        return this.value;
    }

    @Override
    public synchronized int getAndAdd(int delta) {
        int before = this.value;
        this.value += delta;
        return before;
    }

    @Override
    public synchronized int getAndDecrement() {
        return this.value--;
    }

    @Override
    public synchronized int getAndIncrement() {
        return this.value++;
    }

    @Override
    public synchronized int getAndSet(int newValue) {
        int before = this.value;
        this.value = newValue;
        return before;
    }

    @Override
    public synchronized int incrementAndGet() {
        return ++this.value;
    }

    @Override
    public synchronized void set(int newValue) {
        this.value = newValue;
    }

    public synchronized boolean equals(Object obj) {
        try {
            return ((JavaAtomicInteger)obj).value == this.value;
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public synchronized int hashCode() {
        return this.value;
    }

    public synchronized String toString() {
        return String.valueOf(this.value);
    }
}

