/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.encoders;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.encoders.CharacterEncoder;

public class BASE64Encoder
extends CharacterEncoder {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    @Override
    int bytesPerAtom() {
        return 3;
    }

    @Override
    int bytesPerLine() {
        return 57;
    }

    protected char[] getPemArray() {
        return pem_array;
    }

    protected boolean addPadding() {
        return true;
    }

    @Override
    void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
        this.encodeAtom(outStream, data, offset, len, true);
    }

    void encodeAtom(OutputStream outStream, byte[] data, int offset, int len, boolean withPadding) throws IOException {
        if (len == 1) {
            byte a = data[offset];
            int b = 0;
            boolean c = false;
            outStream.write(this.getPemArray()[a >>> 2 & 0x3F]);
            outStream.write(this.getPemArray()[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            if (this.addPadding()) {
                outStream.write(61);
                outStream.write(61);
            }
        } else if (len == 2) {
            byte a = data[offset];
            byte b = data[offset + 1];
            int c = 0;
            outStream.write(this.getPemArray()[a >>> 2 & 0x3F]);
            outStream.write(this.getPemArray()[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            outStream.write(this.getPemArray()[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
            if (this.addPadding()) {
                outStream.write(61);
            }
        } else {
            byte a = data[offset];
            byte b = data[offset + 1];
            byte c = data[offset + 2];
            outStream.write(this.getPemArray()[a >>> 2 & 0x3F]);
            outStream.write(this.getPemArray()[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            outStream.write(this.getPemArray()[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
            outStream.write(this.getPemArray()[c & 0x3F]);
        }
    }

    @Override
    void encodeLineSuffix(OutputStream aStream) throws IOException {
    }
}

