/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.encoders;

public class Base64Bytes {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final int LINE_SEPARATOR_LEN = LINE_SEPARATOR.length();
    static final int SUN_MISC_LINE_LENGTH = 76;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] intToAltBase64 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', ',', '-', '.', ':', ';', '<', '>', '@', '[', ']', '^', '`', '_', '{', '|', '}', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '?'};
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] altBase64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 62, 9, 10, 11, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 12, 13, 14, -1, 15, 63, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, 18, 19, 21, 20, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 22, 23, 24, 25};

    Base64Bytes() {
    }

    public static String byteArrayToBase64(byte[] abyte0, boolean sunMiscCompat) {
        return Base64Bytes.byteArrayToBase64(abyte0, false, sunMiscCompat);
    }

    public static String byteArrayToAltBase64(byte[] abyte0, boolean sunMiscCompat) {
        return Base64Bytes.byteArrayToBase64(abyte0, true, sunMiscCompat);
    }

    private static String byteArrayToBase64(byte[] decodedBytes, boolean altBaseFlag, boolean sunMiscCompat) {
        int decodedByteCount = decodedBytes.length;
        int decodedByteGroups = decodedByteCount / 3;
        int extraBytesCount = decodedByteCount - 3 * decodedByteGroups;
        int encodedStringLength = 4 * ((decodedByteCount + 2) / 3);
        if (sunMiscCompat) {
            int lineCount = encodedStringLength / 76 + 1;
            encodedStringLength += lineCount * LINE_SEPARATOR_LEN;
        }
        StringBuilder resultBuffer = new StringBuilder(encodedStringLength);
        char[] conversionTable = altBaseFlag ? intToAltBase64 : intToBase64;
        int currentBytesPos = 0;
        int linePos = 0;
        for (int encodedCharPos = 0; encodedCharPos < decodedByteGroups; ++encodedCharPos) {
            int byte0 = decodedBytes[currentBytesPos++] & 0xFF;
            int byte1 = decodedBytes[currentBytesPos++] & 0xFF;
            int byte2 = decodedBytes[currentBytesPos++] & 0xFF;
            resultBuffer.append(conversionTable[byte0 >> 2]);
            resultBuffer.append(conversionTable[byte0 << 4 & 0x3F | byte1 >> 4]);
            resultBuffer.append(conversionTable[byte1 << 2 & 0x3F | byte2 >> 6]);
            resultBuffer.append(conversionTable[byte2 & 0x3F]);
            if (!sunMiscCompat || (linePos += 4) != 76) continue;
            resultBuffer.append(LINE_SEPARATOR);
            linePos = 0;
        }
        if (extraBytesCount != 0) {
            int byte0 = decodedBytes[currentBytesPos++] & 0xFF;
            resultBuffer.append(conversionTable[byte0 >> 2]);
            if (extraBytesCount == 1) {
                resultBuffer.append(conversionTable[byte0 << 4 & 0x3F]);
                resultBuffer.append("==");
            } else {
                int byte1 = decodedBytes[currentBytesPos++] & 0xFF;
                resultBuffer.append(conversionTable[byte0 << 4 & 0x3F | byte1 >> 4]);
                resultBuffer.append(conversionTable[byte1 << 2 & 0x3F]);
                resultBuffer.append('=');
            }
            if (sunMiscCompat) {
                resultBuffer.append(LINE_SEPARATOR);
            }
        } else if (sunMiscCompat && linePos != 0) {
            resultBuffer.append(LINE_SEPARATOR);
        }
        return resultBuffer.toString();
    }

    public static byte[] base64ToByteArray(String s, boolean sunMiscCompat) {
        return Base64Bytes.base64ToByteArray(s, false, sunMiscCompat);
    }

    public static byte[] altBase64ToByteArray(String s, boolean sunMiscCompat) {
        return Base64Bytes.base64ToByteArray(s, true, sunMiscCompat);
    }

    private static byte[] base64ToByteArray(String s, boolean flag, boolean sunMiscCompat) {
        int realLength;
        int decodedByteCount;
        byte[] mappingTable = flag ? altBase64ToInt : base64ToInt;
        int encodedLen = s.length();
        int lineEndCharCount = 0;
        int extraLineEndBytes = 0;
        if (sunMiscCompat) {
            int lineCount = encodedLen / (76 + LINE_SEPARATOR_LEN);
            if (lineCount * (76 + LINE_SEPARATOR_LEN) != encodedLen) {
                ++lineCount;
            }
            lineEndCharCount = lineCount * LINE_SEPARATOR_LEN;
            extraLineEndBytes = LINE_SEPARATOR_LEN;
        }
        if (4 * (decodedByteCount = (realLength = encodedLen - lineEndCharCount) / 4) != realLength) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int extraByteCount = 0;
        int bytesToDecodeCount = decodedByteCount;
        if (encodedLen != 0) {
            if (s.charAt(encodedLen - 1 - extraLineEndBytes) == '=') {
                ++extraByteCount;
                --bytesToDecodeCount;
            }
            if (s.charAt(encodedLen - 2 - extraLineEndBytes) == '=') {
                ++extraByteCount;
            }
        }
        byte[] decodedBytes = new byte[3 * decodedByteCount - extraByteCount];
        int encodedCharPos = 0;
        int decodedBytePos = 0;
        int linePos = 0;
        for (int currentBytePos = 0; currentBytePos < bytesToDecodeCount; ++currentBytePos) {
            if (sunMiscCompat && 76 == linePos) {
                encodedCharPos += LINE_SEPARATOR_LEN;
                linePos = 4;
            } else {
                linePos += 4;
            }
            int char0 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            int char1 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            int char2 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            int char3 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            decodedBytes[decodedBytePos++] = (byte)(char0 << 2 | char1 >> 4);
            decodedBytes[decodedBytePos++] = (byte)(char1 << 4 | char2 >> 2);
            decodedBytes[decodedBytePos++] = (byte)(char2 << 6 | char3);
        }
        if (extraByteCount != 0) {
            if (sunMiscCompat && 76 == linePos) {
                encodedCharPos += LINE_SEPARATOR_LEN;
            }
            int l1 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            int j2 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
            decodedBytes[decodedBytePos++] = (byte)(l1 << 2 | j2 >> 4);
            if (extraByteCount == 1) {
                int l2 = Base64Bytes.base64toInt(s.charAt(encodedCharPos++), mappingTable);
                decodedBytes[decodedBytePos++] = (byte)(j2 << 4 | l2 >> 2);
            }
        }
        return decodedBytes;
    }

    private static int base64toInt(char c, byte[] abyte0) {
        byte byte0 = abyte0[c];
        if (byte0 < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return byte0;
    }
}

