/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.encoders;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import weblogic.utils.encoders.ThreadLocalCache;

public class ThreadLocalCoders {
    private static final int CACHE_SIZE = 3;
    private static ThreadLocalCache<String, CharsetDecoder> decoderCache = new ThreadLocalCache<String, CharsetDecoder>(3){

        @Override
        boolean isIncluded(CharsetDecoder value, String name) {
            return value.charset().name().equals(name);
        }

        @Override
        CharsetDecoder createValue(String name) {
            return Charset.forName(name).newDecoder();
        }
    };
    private static ThreadLocalCache<String, CharsetEncoder> encoderCache = new ThreadLocalCache<String, CharsetEncoder>(3){

        @Override
        boolean isIncluded(CharsetEncoder value, String name) {
            return value.charset().name().equals(name);
        }

        @Override
        CharsetEncoder createValue(String name) {
            return Charset.forName(name).newEncoder();
        }
    };

    public static CharsetDecoder getDecoder(String name) {
        CharsetDecoder decoder = decoderCache.findOrCreateByName(name);
        decoder.reset();
        return decoder;
    }

    public static CharsetEncoder getEncoder(String name) {
        CharsetEncoder encoder = encoderCache.findOrCreateByName(name);
        encoder.reset();
        return encoder;
    }
}

