/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import weblogic.utils.enumerations.EmptyFileContainerException;
import weblogic.utils.enumerations.FIFO_FileContainer;
import weblogic.utils.enumerations.FileContainer;
import weblogic.utils.enumerations.LIFO_FileContainer;

public class FileEnumeration
implements Enumeration {
    public static final boolean DEPTH_FIRST = true;
    public static final boolean BREADTH_FIRST = false;
    private File nextFile;
    private boolean depthFirst = true;
    private FileContainer fileContainer;
    public boolean includeDirectories = true;
    public FilenameFilter filter = null;

    private FileContainer getFileContainer() {
        if (this.depthFirst) {
            return new LIFO_FileContainer();
        }
        return new FIFO_FileContainer();
    }

    public boolean getIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(boolean b) {
        this.includeDirectories = b;
    }

    public FileEnumeration() {
    }

    public FileEnumeration(boolean depthFirst) {
        this.depthFirst = depthFirst;
    }

    public FileEnumeration(File topDir) throws FileNotFoundException {
        this.resetTopDir(topDir);
    }

    public FileEnumeration(File topDir, boolean depthFirst) throws FileNotFoundException {
        this.depthFirst = depthFirst;
        this.resetTopDir(topDir);
    }

    public FileEnumeration(File topDir, FilenameFilter filter, boolean depthFirst) throws FileNotFoundException {
        this.filter = filter;
        this.depthFirst = depthFirst;
        this.resetTopDir(topDir);
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public void includeDirectories(boolean includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public void setDepthFirst() {
        this.depthFirst = true;
    }

    public void setBreadthFirst() {
        this.depthFirst = false;
    }

    @Deprecated
    public void reset(File topDir) throws FileNotFoundException {
        this.resetTopDir(topDir);
    }

    public void resetTopDir(File topDir) throws FileNotFoundException {
        if (!topDir.exists()) {
            throw new FileNotFoundException("No such directory: " + topDir);
        }
        if (!topDir.isDirectory()) {
            throw new FileNotFoundException(topDir + " not a directory.");
        }
        this.fileContainer = this.getFileContainer();
        this.fileContainer.push(topDir);
    }

    public synchronized boolean hasMoreFiles() {
        if (this.nextFile == null) {
            this.nextFile = this.getNextFile();
        }
        return this.nextFile != null;
    }

    @Deprecated
    public synchronized File nextFile() {
        return this.next();
    }

    public synchronized File next() {
        if (this.nextFile == null) {
            this.nextFile = this.getNextFile();
        }
        if (this.nextFile == null) {
            throw new NoSuchElementException();
        }
        File n = this.nextFile;
        this.nextFile = null;
        return n;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreFiles();
    }

    public Object nextElement() {
        return this.nextFile();
    }

    private File getNextFile() {
        try {
            String name;
            File dir;
            File next = this.fileContainer.next();
            if (next.isDirectory()) {
                File currentDir = next;
                String[] filenames = currentDir.list();
                if (filenames == null) {
                    throw new NullDirectoryListException(currentDir);
                }
                if (this.depthFirst) {
                    for (int i = filenames.length - 1; i >= 0; --i) {
                        this.fileContainer.push(new File(currentDir, filenames[i]));
                    }
                } else {
                    for (int i = 0; i < filenames.length; ++i) {
                        this.fileContainer.push(new File(currentDir, filenames[i]));
                    }
                }
                if (!this.includeDirectories && (next = this.getNextFile()) == null) {
                    return next;
                }
            }
            if (this.filter == null) {
                return next;
            }
            if (next.isDirectory()) {
                dir = next;
                name = "";
            } else {
                dir = new File(next.getParent());
                name = next.getName();
            }
            return this.filter.accept(dir, name) ? next : this.getNextFile();
        }
        catch (EmptyFileContainerException ese) {
            return null;
        }
    }

    public static class NullDirectoryListException
    extends NullPointerException {
        private NullDirectoryListException(File d) {
            super("An I/O error occurred during listing of the directory: " + d);
        }
    }
}

