/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.enumerations.EnumerationException;
import weblogic.utils.enumerations.PeekingEnumerator;

public class LineEnumerator
extends PeekingEnumerator {
    private DataInputStream dis;

    public LineEnumerator(InputStream in) {
        this.dis = new DataInputStream(in);
    }

    public String nextLine() throws IOException {
        try {
            return (String)this.nextElement();
        }
        catch (EnumerationException ee) {
            throw (IOException)ee.getRealException();
        }
    }

    @Override
    public Object nextObject() {
        try {
            String o = this.dis.readLine();
            return o != null ? o : END;
        }
        catch (IOException ioe) {
            throw new EnumerationException(ioe);
        }
    }
}

