/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.filelock.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jvnet.hk2.annotations.Service;
import weblogic.utils.filelock.FileLockService;

@Service
public class FileLockServiceImpl
implements FileLockService {
    private final Set<File> lockFiles = new LinkedHashSet<File>();

    @Override
    public synchronized void registerLockFile(File file) {
        file.deleteOnExit();
        this.lockFiles.add(file);
    }

    @Override
    public synchronized boolean unregisterLockFile(File file) {
        return this.lockFiles.remove(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLockFiles() {
        RemoveRunnable removeLockFileTask;
        FileLockServiceImpl fileLockServiceImpl = this;
        synchronized (fileLockServiceImpl) {
            removeLockFileTask = new RemoveRunnable(this.lockFiles);
            this.lockFiles.clear();
        }
        Thread removeLockFileThread = new Thread(removeLockFileTask);
        removeLockFileThread.setDaemon(true);
        removeLockFileThread.start();
        return removeLockFileTask.waitForFinish(1000L);
    }

    private static final class RemoveRunnable
    implements Runnable {
        private final List<File> toRemove;
        private boolean finished = false;

        private RemoveRunnable(Set<File> currentList) {
            this.toRemove = new LinkedList<File>(currentList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (File removeMe : this.toRemove) {
                    try {
                        removeMe.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                RemoveRunnable removeRunnable = this;
                synchronized (removeRunnable) {
                    this.finished = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForFinish(long waitTime) {
            RemoveRunnable removeRunnable = this;
            synchronized (removeRunnable) {
                long elapsedTime = System.currentTimeMillis();
                while (!this.finished && waitTime > 0L) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ie) {
                        waitTime = 0L;
                    }
                    elapsedTime = System.currentTimeMillis() - elapsedTime;
                    waitTime -= elapsedTime;
                }
                return this.finished;
            }
        }
    }
}

