/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.RequestParser;
import weblogic.utils.io.FilenameEncoder;

public abstract class AbstractHttpRequestParser
implements RequestParser {
    protected String scheme;
    protected String method;
    protected byte[] buf;
    protected int bufLen = 0;
    protected int pos = 0;
    protected int queryStringStart = -1;
    protected int queryStringLength = -1;
    protected int requestUriStart = -1;
    protected int requestUriLength = -1;
    protected int fullRequestUriStart = -1;
    protected int originalUriLength = -1;
    protected String requestURI;
    protected String normalizedURI;
    private List<String> pathParameters;
    protected static final String ENCODING;
    private Map<String, String> trailers = new HashMap<String, String>();
    private boolean trailerFieldsReady = false;
    protected static final byte[] methodValidateArray;
    protected static final String URI_DECODE_ENCODING;
    protected final ArrayList headerNames = new ArrayList(16);
    protected final ArrayList headerValues = new ArrayList(16);

    public static String getURIDecodeEncoding() {
        return URI_DECODE_ENCODING;
    }

    @Override
    public void initFromRequstParser(RequestParser baseParser) {
        this.method = baseParser.getMethod();
        this.scheme = baseParser.getScheme();
        this.headerNames.addAll(baseParser.getHeaderNames());
        this.headerValues.addAll(baseParser.getHeaderValues());
        if (baseParser instanceof AbstractHttpRequestParser) {
            AbstractHttpRequestParser abstractBaseParser = (AbstractHttpRequestParser)baseParser;
            this.buf = abstractBaseParser.buf;
            this.bufLen = abstractBaseParser.bufLen;
            this.requestUriStart = abstractBaseParser.requestUriStart;
            this.requestUriLength = abstractBaseParser.requestUriLength;
        }
        this.queryStringStart = baseParser.getQueryStringStart();
        this.queryStringLength = baseParser.getQueryStringLength();
        this.requestURI = baseParser.getRequestURI();
        this.normalizedURI = baseParser.getNormalizedURI();
        this.pathParameters = baseParser.getPathParameters();
    }

    @Override
    public void reset() {
        this.method = null;
        this.headerNames.clear();
        this.headerValues.clear();
        this.buf = null;
        this.bufLen = 0;
        this.pos = 0;
        this.queryStringStart = -1;
        this.queryStringLength = -1;
        this.requestUriStart = -1;
        this.requestUriLength = -1;
        this.originalUriLength = -1;
        this.requestURI = null;
        this.normalizedURI = null;
        this.pathParameters = null;
    }

    @Override
    public void addHeader(String name, byte[] value) {
        this.headerNames.add(name);
        this.headerValues.add(value);
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public List<String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public String getNormalizedURI() {
        return this.normalizedURI;
    }

    @Override
    public void setScheme(String s) {
        this.scheme = s;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String s) {
        this.method = s;
    }

    @Override
    public byte[] getHttpRequestBuffer() {
        return this.buf;
    }

    @Override
    public int getQueryStringStart() {
        return this.queryStringStart;
    }

    @Override
    public int getQueryStringLength() {
        return this.queryStringLength;
    }

    @Override
    public void addTrailerField(String name, String value) {
        this.trailers.put(name, value);
    }

    @Override
    public Map<String, String> getTrailers() {
        return this.trailers;
    }

    @Override
    public void markTrailerFieldsReady() {
        this.trailerFieldsReady = true;
    }

    @Override
    public boolean isTrailerFieldsReady() {
        return this.trailerFieldsReady;
    }

    @Override
    public ArrayList getHeaderNames() {
        return this.headerNames;
    }

    @Override
    public ArrayList getHeaderValues() {
        return this.headerValues;
    }

    @Override
    public byte[] getHeader(String name) {
        for (int i = 0; i < this.headerNames.size(); ++i) {
            String n = (String)this.headerNames.get(i);
            if (!name.equalsIgnoreCase(n)) continue;
            return (byte[])this.headerValues.get(i);
        }
        return null;
    }

    protected boolean isCR(byte b) {
        return b == 13;
    }

    protected boolean isLF(byte b) {
        return b == 10;
    }

    protected boolean isCRLF() {
        return this.isCR(this.buf[this.pos]) || this.isLF(this.buf[this.pos]);
    }

    protected boolean isSpace() {
        return this.buf[this.pos] == 32;
    }

    protected boolean isSpaceTab(byte b) {
        return b == 32 || b == 9;
    }

    protected boolean isSpaceTab() {
        return this.isSpaceTab(this.buf[this.pos]);
    }

    protected boolean isSlash() {
        return this.buf[this.pos] == 47;
    }

    protected boolean cmp(byte[] a, int off, byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (a[off + i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected int incPos(int count) {
        this.pos += count;
        this.checkOverflow(this.pos);
        return this.pos;
    }

    protected void consumeSpaces() {
        while (this.isSpace()) {
            this.incPos(1);
        }
    }

    protected void checkOverflow(int count) {
        if (count > this.bufLen) {
            throw new ArrayIndexOutOfBoundsException("overflow detected");
        }
    }

    protected void decodeURI(int start, List<Integer> pathParamIndexes, int end) {
        this.requestUriStart = start;
        this.requestUriLength = end - start;
        this.requestURI = BytesToString.newString(this.buf, this.requestUriStart, this.requestUriLength, ENCODING);
        String uri = null;
        if (pathParamIndexes == null || pathParamIndexes.size() == 0) {
            uri = HttpParsing.unescape(this.requestURI, AbstractHttpRequestParser.getURIDecodeEncoding());
        } else {
            ByteArrayOutputStream normalizedURIBytes = new ByteArrayOutputStream();
            this.pathParameters = new ArrayList<String>();
            int slashIdx = start;
            block0: for (int semicolonIdx : pathParamIndexes) {
                if (semicolonIdx <= slashIdx) continue;
                normalizedURIBytes.write(this.buf, slashIdx, semicolonIdx - slashIdx);
                for (int idx = semicolonIdx + 1; idx < end; ++idx) {
                    if (this.buf[idx] == 47) {
                        slashIdx = idx;
                        this.pathParameters.add(BytesToString.newString(this.buf, semicolonIdx, slashIdx - semicolonIdx, ENCODING));
                        continue block0;
                    }
                    if (idx != end - 1) continue;
                    slashIdx = end;
                    this.pathParameters.add(BytesToString.newString(this.buf, semicolonIdx, slashIdx - semicolonIdx, ENCODING));
                }
            }
            if (slashIdx > pathParamIndexes.get(pathParamIndexes.size() - 1) && end > slashIdx) {
                normalizedURIBytes.write(this.buf, slashIdx, end - slashIdx);
            }
            uri = HttpParsing.unescape(normalizedURIBytes == null ? this.requestURI : BytesToString.newString(normalizedURIBytes.toByteArray(), ENCODING), AbstractHttpRequestParser.getURIDecodeEncoding());
        }
        this.normalizedURI = FilenameEncoder.resolveRelativeURIPath(uri, true);
        if (this.normalizedURI != null) {
            this.normalizedURI = HttpParsing.ensureStartingSlash(this.normalizedURI);
        }
    }

    @Override
    public ByteBuffer getOriginalRequestUriBytes() {
        return this.originalUriLength == -1 ? null : ByteBuffer.wrap(this.buf, this.requestUriStart, this.originalUriLength);
    }

    static {
        methodValidateArray = new byte[]{1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1};
        ENCODING = System.getProperty("file.encoding");
        String encoding = System.getProperty("weblogic.http.URIDecodeEncoding");
        URI_DECODE_ENCODING = encoding != null && (encoding = encoding.trim()).length() != 0 ? encoding : "UTF-8";
    }
}

