/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.UnsupportedEncodingException;
import weblogic.utils.StringUtils;

public final class BytesToString {
    public static String newString(byte[] b, String enc) {
        return BytesToString.newString(b, 0, b.length, enc);
    }

    public static String newString(byte[] b, int offset, int length, String enc) {
        if (BytesToString.is8BitUnicodeSubset(enc)) {
            return BytesToString.newAsciiString(b, offset, length);
        }
        return BytesToString.newNonAsciiString(b, offset, length, enc);
    }

    public static String newAsciiString(byte[] b, int offset, int length) {
        return StringUtils.getString(b, offset, length);
    }

    public static String newNonAsciiString(byte[] b, int offset, int length, String enc) {
        try {
            return new String(b, offset, length, enc);
        }
        catch (UnsupportedEncodingException uee) {
            return StringUtils.getString(b, offset, length);
        }
    }

    public static boolean is8BitUnicodeSubset(String enc) {
        return enc == null || "ISO-8859-1".equalsIgnoreCase(enc) || "ISO8859_1".equalsIgnoreCase(enc) || "ASCII".equalsIgnoreCase(enc);
    }
}

