/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import weblogic.utils.Hex;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.utils.http.ChunkMaxPostSizeExceededException;
import weblogic.utils.http.RequestParser;

public class HttpChunkInputStream
extends FilterInputStream {
    private long currentChunkSize = -1L;
    private long chunkDataRead = 0L;
    private boolean zeroChunk = false;
    private byte[] buf = null;
    private int rdptr = -1;
    private int wtptr = -1;
    private int maxPostSize = -1;
    private long totalCurrentChunkSize = 0L;
    private boolean isReset = false;
    private boolean chunkEndingCRLFConsumed = false;
    private boolean isEOF = false;
    private RequestParser requestParser = null;
    private List<String> trailerHeaders = null;
    private String inputEncoding = null;

    private void initChunk() throws IOException {
        if (this.zeroChunk) {
            return;
        }
        if (this.currentChunkSize > 0L && this.chunkDataRead < this.currentChunkSize) {
            return;
        }
        try {
            this.consumeChunkEndingCRLF();
            this.currentChunkSize = this.readChunkSize();
            this.totalCurrentChunkSize += this.currentChunkSize;
            this.checkPostSize();
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        this.chunkDataRead = 0L;
        this.chunkEndingCRLFConsumed = false;
        if (this.currentChunkSize == 0L) {
            this.zeroChunk = true;
            this.consumeTrailerPartAndLastCRLF();
        }
    }

    private void consumeTrailerPartAndLastCRLF() throws IOException {
        boolean lastCRLF = false;
        if (this.trailerHeaders == null || this.trailerHeaders.size() == 0) {
            int readByte;
            while (!lastCRLF && (readByte = this.in.read()) != -1) {
                if (readByte != 13) continue;
                if (this.in.read() != 10) {
                    throw new IOException("Malformed chunk");
                }
                lastCRLF = true;
                this.chunkEndingCRLFConsumed = true;
                if (this.requestParser == null) continue;
                this.requestParser.markTrailerFieldsReady();
            }
        } else {
            int readByte;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            block1: while (!lastCRLF && (readByte = this.in.read()) != -1) {
                if (readByte == 13) {
                    if (this.in.read() != 10) {
                        throw new IOException("Malformed chunk");
                    }
                    lastCRLF = true;
                    this.chunkEndingCRLFConsumed = true;
                    this.requestParser.markTrailerFieldsReady();
                    continue;
                }
                bos.write(readByte);
                while ((readByte = this.in.read()) != -1) {
                    if (readByte == 13) {
                        if (this.in.read() != 10) {
                            throw new IOException("Malformed chunk");
                        }
                        String trailerHeaderField = bos.toString(this.inputEncoding);
                        bos.reset();
                        int colonPos = trailerHeaderField.indexOf(58);
                        String trailerHeaderName = trailerHeaderField.substring(0, colonPos).trim();
                        if (this.trailerHeaders != null && this.trailerHeaders.contains(trailerHeaderName)) {
                            String trailerHeaderValue = trailerHeaderField.substring(colonPos + 1).trim();
                            this.requestParser.addTrailerField(trailerHeaderName, trailerHeaderValue);
                            continue block1;
                        }
                        throw new IOException("Unexpected trailer header " + trailerHeaderName);
                    }
                    bos.write(readByte);
                }
            }
            if (this.requestParser.getTrailers().size() != this.trailerHeaders.size()) {
                throw new IOException("The trailer part in chunk is inconsistent with Trailer header");
            }
        }
        if (!lastCRLF) {
            throw new IOException("Malformed chunk");
        }
    }

    private void checkPostSize() throws IOException {
        if (this.maxPostSize > 0 && this.totalCurrentChunkSize > (long)this.maxPostSize) {
            throw new ChunkMaxPostSizeExceededException(this.totalCurrentChunkSize, this.maxPostSize);
        }
    }

    private void consumeChunkEndingCRLF() throws IOException {
        if (this.currentChunkExhausts() && !this.chunkEndingCRLFConsumed) {
            if (this.in.read() != 13 || this.in.read() != 10) {
                throw new IOException("Malformed chunk");
            }
            this.chunkEndingCRLFConsumed = true;
        }
    }

    private int readChunkSize() throws IOException {
        int b;
        UnsyncStringBuffer sb = new UnsyncStringBuffer();
        int chunkSize = 0;
        boolean ext = false;
        while ((b = this.in.read()) != -1 && (b != 13 || (b = this.in.read()) != 10)) {
            char c = (char)b;
            if (!ext && Hex.isHexChar(c)) {
                sb.append(c);
                continue;
            }
            ext = true;
        }
        chunkSize = Integer.parseInt(sb.toString(), 16);
        return chunkSize;
    }

    public HttpChunkInputStream(InputStream is) {
        super(is);
    }

    public HttpChunkInputStream(InputStream is, int aMaxPostSize) {
        super(is);
        this.maxPostSize = aMaxPostSize;
    }

    public HttpChunkInputStream(InputStream is, int maxPostSize, RequestParser requestParser) {
        this(is, maxPostSize);
        this.requestParser = requestParser;
    }

    public HttpChunkInputStream(InputStream is, int maxPostSize, RequestParser requestParser, List<String> trailerHeaders, String inputEncoding) {
        this(is, maxPostSize, requestParser);
        this.trailerHeaders = trailerHeaders;
        this.inputEncoding = inputEncoding;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpened();
        if (this.shouldReadFromBuffer()) {
            return this.readFromBuffer();
        }
        this.initChunk();
        if (this.zeroChunk) {
            return -1;
        }
        int b = this.in.read();
        if (b == -1) {
            return -1;
        }
        this.writeToBuffer(b);
        ++this.chunkDataRead;
        return b;
    }

    private boolean shouldReadFromBuffer() {
        return this.rdptr >= 0 && this.rdptr < this.wtptr && this.isReset;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bytesRead = 0;
        if (this.shouldReadFromBuffer()) {
            int toRead = Math.min(len, this.wtptr - this.rdptr);
            System.arraycopy(this.buf, this.rdptr, b, off, toRead);
            bytesRead += toRead;
            this.rdptr += toRead;
            off += toRead;
            len -= toRead;
        }
        while (len > 0) {
            long remainingChunk;
            int toRead;
            int latestBytesRead;
            this.initChunk();
            if (this.zeroChunk || bytesRead != 0 && this.in.available() < len || (latestBytesRead = this.in.read(b, off, toRead = (int)Math.min(remainingChunk = this.currentChunkSize - this.chunkDataRead, (long)len))) == -1) break;
            this.writeToBuffer(b, off, latestBytesRead);
            bytesRead += latestBytesRead;
            off += latestBytesRead;
            len -= latestBytesRead;
            this.chunkDataRead += (long)latestBytesRead;
            if (!this.currentChunkExhausts()) continue;
            break;
        }
        if (bytesRead == 0) {
            return -1;
        }
        return bytesRead;
    }

    public boolean currentChunkExhausts() {
        return this.chunkDataRead >= this.currentChunkSize && this.currentChunkSize >= 0L;
    }

    public long unConsumedChunkSize() {
        return this.currentChunkSize - this.chunkDataRead;
    }

    private long skip() throws IOException {
        this.initChunk();
        if (this.zeroChunk) {
            return -1L;
        }
        long bytesToSkip = this.currentChunkSize - this.chunkDataRead;
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        if (this.in.read() == -1) {
            this.isEOF = true;
            return 0L;
        }
        long skipped = this.in.skip(bytesToSkip - 1L);
        this.chunkDataRead += skipped + 1L;
        return skipped + 1L;
    }

    @Override
    public long skip(long n) throws IOException {
        long x;
        this.ensureOpened();
        if (n <= 0L) {
            return 0L;
        }
        long skipped = 0L;
        if (this.shouldReadFromBuffer()) {
            if ((long)(this.wtptr - this.rdptr) >= n) {
                this.rdptr = (int)((long)this.rdptr + n);
                return n;
            }
            skipped = this.wtptr - this.rdptr;
            this.rdptr = -1;
            this.wtptr = -1;
            this.buf = null;
            this.isReset = false;
        }
        while (n - skipped >= this.currentChunkSize) {
            x = this.skip();
            if (x == -1L) {
                return skipped;
            }
            skipped += x;
        }
        if (n > skipped) {
            this.initChunk();
            if (this.zeroChunk) {
                return skipped;
            }
            x = this.in.skip(n - skipped);
            this.chunkDataRead += x;
            if (x == -1L) {
                return skipped;
            }
            skipped += x;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpened();
        this.consumeChunkEndingCRLF();
        int n = this.wtptr - this.rdptr;
        int avail = this.zeroChunk ? 0 : this.in.available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }

    private void ensureOpened() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.skipAllChunk();
        this.in.close();
        this.in = null;
    }

    @Override
    public synchronized void mark(int n) {
        if (n <= 0 || this.zeroChunk) {
            return;
        }
        if (this.buf == null) {
            this.buf = new byte[n];
            this.wtptr = 0;
            this.rdptr = 0;
        } else if (this.wtptr == 0 && this.rdptr == this.wtptr) {
            if (n != this.buf.length) {
                this.buf = new byte[n];
            }
        } else if (this.rdptr >= 0 && this.isReset) {
            int rem = this.wtptr - this.rdptr;
            byte[] tmp = n > this.buf.length ? new byte[n] : this.buf;
            System.arraycopy(this.buf, this.rdptr, tmp, 0, rem);
            this.wtptr = rem;
            this.rdptr = 0;
            this.buf = tmp;
        } else {
            this.buf = new byte[n];
            this.wtptr = 0;
            this.rdptr = 0;
        }
    }

    private byte readFromBuffer() {
        byte x = this.buf[this.rdptr];
        ++this.rdptr;
        return x;
    }

    private void writeToBuffer(int b) {
        if (this.buf == null) {
            return;
        }
        if (this.buf.length <= this.wtptr) {
            this.buf = null;
            this.rdptr = -1;
            this.wtptr = -1;
            this.isReset = false;
            return;
        }
        this.buf[this.wtptr] = (byte)b;
        ++this.wtptr;
        ++this.rdptr;
    }

    private void writeToBuffer(byte[] bytes, int off, int len) {
        if (this.buf == null) {
            return;
        }
        if (this.buf.length < this.wtptr + len) {
            this.buf = null;
            this.rdptr = -1;
            this.wtptr = -1;
            this.isReset = false;
            return;
        }
        System.arraycopy(bytes, off, this.buf, this.wtptr, len);
        this.wtptr += len;
        this.rdptr += len;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.ensureOpened();
        if (this.wtptr == -1) {
            throw new IOException("marked position is invalid");
        }
        this.rdptr = 0;
        this.isReset = true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public boolean hasUnconsumedChunk() {
        return !this.zeroChunk;
    }

    public void skipAllChunk() throws IOException {
        while (this.hasUnconsumedChunk() && !this.isEOF) {
            this.skip();
        }
    }
}

