/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.Debug;
import weblogic.utils.io.Chunk;

public class HttpChunkOutputStream
extends FilterOutputStream {
    private final int httpChunkSize;
    private int chunkCount;
    private final Chunk head;
    private Chunk cur;
    private boolean isClosed;
    private static boolean DEBUG = false;
    private static int CHUNK_HEADER_SIZE = 6;
    private static int CHUNK_TAIL_SIZE = 2;
    private static byte CR = (byte)13;
    private static byte LF = (byte)10;
    private static byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public HttpChunkOutputStream(OutputStream out) throws IOException {
        this(out, Chunk.CHUNK_SIZE - CHUNK_HEADER_SIZE - CHUNK_TAIL_SIZE);
    }

    public HttpChunkOutputStream(OutputStream out, int size) throws IOException {
        super(out);
        if (size > 65536) {
            throw new IOException("chunk size should be less than 64k");
        }
        this.httpChunkSize = size;
        this.head = Chunk.getChunk();
        this.initChunkHead();
        if (DEBUG) {
            Debug.say("init " + size);
        }
    }

    private void initChunkHead() {
        this.cur = this.head;
        this.cur.end = CHUNK_HEADER_SIZE;
        this.chunkCount = 0;
    }

    private int getByteCount() {
        return this.chunkCount * Chunk.CHUNK_SIZE + this.cur.end - CHUNK_HEADER_SIZE;
    }

    private int ensureCapacity() {
        if (this.cur.end < Chunk.CHUNK_SIZE) {
            return Chunk.CHUNK_SIZE - this.cur.end;
        }
        if (this.cur.next == null) {
            this.cur.next = Chunk.getChunk();
        } else {
            this.cur.next.end = 0;
        }
        this.cur = this.cur.next;
        ++this.chunkCount;
        if (DEBUG) {
            Debug.say("adding chunk chunkCount=" + this.chunkCount);
        }
        return Chunk.CHUNK_SIZE;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = (byte)b;
        if (this.getByteCount() == this.httpChunkSize) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void writeToChunks(byte[] b, int off, int len) throws IOException {
        int toWrite;
        do {
            int capacity;
            int n = toWrite = len <= (capacity = this.ensureCapacity()) ? len : capacity;
            if (DEBUG) {
                Debug.say(" off= " + off + " len=" + len + " toWrite=" + toWrite + " cur.end=" + this.cur.end);
            }
            System.arraycopy(b, off, this.cur.buf, this.cur.end, toWrite);
            this.cur.end += toWrite;
            off += toWrite;
        } while ((len -= toWrite) > 0);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        int bytes2flush = this.httpChunkSize - this.getByteCount();
        if (DEBUG) {
            Debug.say("direct write off=" + off + " len=" + len + " bytes2flush=" + bytes2flush);
        }
        if (len < bytes2flush) {
            this.writeToChunks(b, off, len);
            return;
        }
        do {
            this.writeToChunks(b, off, bytes2flush);
            off += bytes2flush;
            if ((len -= bytes2flush) >= 0) {
                this.flush();
                bytes2flush = this.httpChunkSize - this.getByteCount();
                if (len < bytes2flush) {
                    bytes2flush = len;
                }
            }
            if (!DEBUG) continue;
            Debug.say("flush write off=" + off + " len=" + len + " bytes2flush=" + bytes2flush);
        } while (len > 0);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.flush();
        this.writeChunkHeader(0);
        this.head.buf[this.head.end++] = CR;
        this.head.buf[this.head.end++] = LF;
        this.out.write(this.head.buf, 0, this.head.end);
        this.out.flush();
        Chunk.releaseChunks(this.head);
        this.isClosed = true;
    }

    private void writeChunkHeader(int chunkSize) {
        int pos = 4;
        do {
            this.head.buf[--pos] = HEX_DIGITS[chunkSize & 0xF];
        } while ((chunkSize >>>= 4) != 0);
        for (int j = 0; j < pos; ++j) {
            this.head.buf[j] = 48;
        }
        this.head.buf[4] = CR;
        this.head.buf[5] = LF;
        if (DEBUG) {
            Debug.say("chunk header 0x" + new String(this.head.buf, 0, 4));
        }
    }

    @Override
    public void flush() throws IOException {
        int n = this.getByteCount();
        if (this.isClosed || n == 0) {
            return;
        }
        this.writeChunkHeader(n);
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = CR;
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = LF;
        Chunk c = this.head;
        while (c != null) {
            this.out.write(c.buf, 0, c.end);
            if (DEBUG) {
                Debug.say("flush writing bytes " + c.end);
            }
            if (c == this.cur) break;
            c = c.next;
        }
        this.out.flush();
        this.initChunkHead();
    }
}

