/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.utils.StringUtils;
import weblogic.utils.http.AbstractHttpRequestParser;
import weblogic.utils.http.HttpConstants;
import weblogic.utils.http.HttpRequestParseException;
import weblogic.utils.http.RequestParser;

public final class HttpRequestParser
extends AbstractHttpRequestParser
implements RequestParser {
    private static final ByteBufferCache byteBufferCache = new ByteBufferCache(Integer.getInteger("weblogic.http.ByteBufferMaxLen", 128), Integer.getInteger("weblogic.http.ByteBufferEntryCount", 16));
    private String protocol;
    private boolean keepAlive;
    private int totalHeadersSize;
    private int singleHeaderSize;
    private int maxSingleHeaderSize = -1;
    private int maxTotalHeadersSize = -1;

    public HttpRequestParser() {
    }

    public HttpRequestParser(byte[] buf, int bufLen) throws HttpRequestParseException {
        this.parse(buf, bufLen);
    }

    public HttpRequestParser(String method, String protocol, String uri) {
        this();
        this.method = method;
        this.protocol = protocol;
        this.requestURI = uri;
    }

    @Override
    public void parse(byte[] buf, int bufLen) throws HttpRequestParseException {
        this.parse(buf, bufLen, -1, -1);
    }

    @Override
    public void parse(byte[] buf, int bufLen, int maxSingleHeaderSize, int maxTotalHeadersSize) throws HttpRequestParseException {
        this.buf = buf;
        this.bufLen = bufLen;
        this.maxSingleHeaderSize = maxSingleHeaderSize;
        this.maxTotalHeadersSize = maxTotalHeadersSize;
        this.parse();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void reset() {
        super.reset();
        this.protocol = null;
        this.keepAlive = false;
        this.totalHeadersSize = 0;
        this.singleHeaderSize = 0;
        this.maxTotalHeadersSize = -1;
        this.maxSingleHeaderSize = -1;
    }

    @Override
    public void initFromRequstParser(RequestParser baseParser) {
        super.initFromRequstParser(baseParser);
        if (baseParser instanceof HttpRequestParser) {
            HttpRequestParser httpBaseParser = (HttpRequestParser)baseParser;
            this.protocol = httpBaseParser.protocol;
            this.keepAlive = httpBaseParser.keepAlive;
        }
    }

    public String toString() {
        return "[HttpRequestParser] method: " + this.method + " requestURI: " + this.normalizedURI + " protocol: " + this.protocol;
    }

    private void parse() throws HttpRequestParseException {
        try {
            this.startLine();
            this.headers();
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new HttpRequestParseException("Request parsing failed", e, this);
        }
    }

    private void validate() throws HttpRequestParseException {
        if (this.method == null || this.method.length() == 0) {
            throw new HttpRequestParseException("Method was not set");
        }
        if (this.protocol == null || this.protocol.length() == 0) {
            throw new HttpRequestParseException("Protocol was not set");
        }
    }

    private void startLine() throws HttpRequestParseException {
        this.oldCRLF();
        this.fullRequestUriStart = this.pos;
        this.method();
        this.uri_protocol();
        this.crlf();
    }

    private int crlf() throws HttpRequestParseException {
        switch (this.buf[this.pos++]) {
            case 13: {
                if (this.buf[this.pos++] == 10) {
                    this.checkOverflow(this.pos);
                    return 2;
                }
                this.checkOverflow(this.pos);
                break;
            }
            case 10: {
                if (this.buf[this.pos] == 13) {
                    this.incPos(1);
                    return 2;
                }
                this.checkOverflow(this.pos);
                return 1;
            }
        }
        throw new HttpRequestParseException("Expected CRLF", this);
    }

    private void oldCRLF() {
        while (this.isCRLF()) {
            this.incPos(1);
        }
    }

    private void method() throws HttpRequestParseException {
        int methodBegin = this.pos;
        while (!this.isSpace()) {
            this.incPos(1);
        }
        if (this.buf[methodBegin] == 71 && this.buf[methodBegin + 1] == 69 && this.buf[methodBegin + 2] == 84 && this.buf[methodBegin + 3] == 32) {
            this.method = "GET";
        } else if (this.buf[methodBegin] == 80 && this.buf[methodBegin + 1] == 79 && this.buf[methodBegin + 2] == 83 && this.buf[methodBegin + 3] == 84 && this.buf[methodBegin + 4] == 32) {
            this.method = "POST";
        } else if (this.buf[methodBegin] == 80 && this.buf[methodBegin + 1] == 85 && this.buf[methodBegin + 2] == 84 && this.buf[methodBegin + 3] == 32) {
            this.method = "PUT";
        } else if (this.buf[methodBegin] == 72 && this.buf[methodBegin + 1] == 69 && this.buf[methodBegin + 2] == 65 && this.buf[methodBegin + 3] == 68) {
            this.method = "HEAD";
        } else if (this.buf[methodBegin] == 84 && this.buf[methodBegin + 1] == 82 && this.buf[methodBegin + 2] == 65 && this.buf[methodBegin + 3] == 67 && this.buf[methodBegin + 4] == 69 && this.buf[methodBegin + 5] == 32) {
            this.method = "TRACE";
        } else {
            this.validateMethodName(this.buf, methodBegin, this.pos);
            this.method = StringUtils.getString(this.buf, methodBegin, this.pos - methodBegin);
        }
    }

    private void validateMethodName(byte[] buf, int startIndex, int endInedx) throws HttpRequestParseException {
        for (int i = startIndex; i < endInedx; ++i) {
            if (buf[i] <= 126 && buf[i] >= 33) {
                if (methodValidateArray[buf[i] - 33] != 0) continue;
            }
            throw new HttpRequestParseException("Invalid HTTP Method", this);
        }
    }

    private void parseProtocol(int start, int end) {
        if (end - start == 8 && this.buf[start] == 72) {
            byte v = this.buf[start + 7];
            if (v == 48) {
                this.protocol = "HTTP/1.0";
                return;
            }
            if (v == 49) {
                this.protocol = "HTTP/1.1";
                return;
            }
        }
        this.protocol = StringUtils.getString(this.buf, start, end - start);
    }

    private boolean isAbsHTTP() {
        try {
            this.checkOverflow(this.pos + 6);
            return this.buf[this.pos] == 104 && this.buf[this.pos + 1] == 116 && this.buf[this.pos + 2] == 116 && this.buf[this.pos + 3] == 112 && this.buf[this.pos + 4] == 58 && this.buf[this.pos + 5] == 47 && this.buf[this.pos + 6] == 47;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean isAbsHTTPS() {
        try {
            this.checkOverflow(this.pos + 7);
            return this.buf[this.pos] == 104 && this.buf[this.pos + 1] == 116 && this.buf[this.pos + 2] == 116 && this.buf[this.pos + 3] == 112 && this.buf[this.pos + 4] == 115 && this.buf[this.pos + 5] == 58 && this.buf[this.pos + 6] == 47 && this.buf[this.pos + 7] == 47;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    private void skipAbsURI() {
        block3: {
            block2: {
                if (!this.isAbsHTTP()) break block2;
                this.incPos(7);
                while (!this.isSlash()) {
                    this.incPos(1);
                }
                break block3;
            }
            if (!this.isAbsHTTPS()) break block3;
            this.incPos(8);
            while (!this.isSlash()) {
                this.incPos(1);
            }
        }
    }

    private void skipMultipleSlashes() {
        while (this.isSlash() && this.pos + 2 <= this.bufLen && this.buf[this.pos + 1] == 47) {
            this.incPos(1);
        }
    }

    private void uri_protocol() throws HttpRequestParseException {
        boolean unsafeSymbolsInUri = false;
        this.consumeSpaces();
        this.skipAbsURI();
        this.skipMultipleSlashes();
        int queryStrIndex = -1;
        ArrayList<Integer> pathParamIndexes = null;
        int uriBegin = this.pos;
        while (!this.isSpace() && !this.isCRLF()) {
            if (this.buf[this.pos] == 63 && queryStrIndex == -1) {
                queryStrIndex = this.pos;
            } else if (this.buf[this.pos] == 59 && queryStrIndex == -1) {
                if (pathParamIndexes == null) {
                    pathParamIndexes = new ArrayList<Integer>();
                }
                pathParamIndexes.add(this.pos);
            } else if (this.buf[this.pos] == 60 && queryStrIndex == -1) {
                unsafeSymbolsInUri = true;
            }
            this.incPos(1);
        }
        int uriEnd = this.pos;
        this.consumeSpaces();
        if (this.isCRLF()) {
            this.protocol = "HTTP/0.9";
        } else {
            int protocolBegin = this.pos;
            int protocolEnd = -1;
            while (true) {
                if (this.isCRLF()) break;
                if (this.isSpace()) {
                    uriEnd = this.pos;
                    this.consumeSpaces();
                    protocolBegin = this.pos;
                    continue;
                }
                if (this.buf[this.pos] == 63) {
                    queryStrIndex = queryStrIndex == -1 ? this.pos : queryStrIndex;
                    this.incPos(1);
                    continue;
                }
                if (this.buf[this.pos] == 59 && queryStrIndex == -1) {
                    if (pathParamIndexes == null) {
                        pathParamIndexes = new ArrayList();
                    }
                    pathParamIndexes.add(this.pos);
                    this.incPos(1);
                    continue;
                }
                this.incPos(1);
            }
            protocolEnd = this.pos;
            this.parseProtocol(protocolBegin, protocolEnd);
        }
        this.keepAlive = "HTTP/1.1".equalsIgnoreCase(this.protocol);
        if (queryStrIndex > uriEnd) {
            queryStrIndex = -1;
        }
        this.originalUriLength = uriEnd - uriBegin;
        if (queryStrIndex == -1) {
            this.decodeURI(uriBegin, pathParamIndexes, uriEnd);
        } else {
            this.decodeURI(uriBegin, pathParamIndexes, queryStrIndex);
            this.queryStringStart = queryStrIndex + 1;
            this.queryStringLength = uriEnd - (queryStrIndex + 1);
        }
        if (unsafeSymbolsInUri) {
            throw new HttpRequestParseException("Request contains XSS script", this);
        }
    }

    private void headers() throws HttpRequestParseException {
        this.totalHeadersSize = 0;
        while (true) {
            if (this.isCRLF()) {
                while (this.pos < this.bufLen && this.isCRLF()) {
                    this.incPos(1);
                }
                return;
            }
            this.header();
        }
    }

    private void header() throws HttpRequestParseException {
        this.singleHeaderSize = 0;
        String headerName = this.headerName();
        this.headerColon();
        byte[] headerValue = this.headerValue();
        this.headerNames.add(headerName);
        this.headerValues.add(headerValue);
        this.processSpecialHeaders(headerName, headerValue);
        this.crlf();
    }

    private void processSpecialHeaders(String headerName, byte[] headerValue) {
        switch (headerName.length()) {
            case 10: {
                if (!"Connection".equalsIgnoreCase(headerName)) break;
                this.connection(headerValue);
                break;
            }
        }
    }

    private boolean startsWith(byte[] b, byte[] str, int off) {
        for (int i = 0; i < str.length; ++i) {
            if (b[i + off] == str[i]) continue;
            return false;
        }
        return true;
    }

    private boolean contains(byte[] b, byte[] str) {
        if (b.length < str.length) {
            return false;
        }
        for (int i = 0; i < b.length - str.length + 1; ++i) {
            if (!this.startsWith(b, str, i)) continue;
            return true;
        }
        return false;
    }

    private void connection(byte[] value) {
        if (this.contains(value, HttpConstants.KEEP_ALIVE_BYTES)) {
            this.keepAlive = true;
        } else if (this.contains(value, HttpConstants.KEEP_ALIVE_IE_BYTES)) {
            this.keepAlive = true;
        } else {
            String s = StringUtils.getString(value);
            if (StringUtils.indexOfIgnoreCase(s, "keep-alive") >= 0) {
                this.keepAlive = true;
            } else if (StringUtils.indexOfIgnoreCase(s, "close") >= 0) {
                this.keepAlive = false;
            }
        }
    }

    private String headerName() throws HttpRequestParseException {
        int headerNameStart = this.pos;
        boolean invalid = false;
        while (this.buf[this.pos] != 58) {
            if (this.buf[this.pos] == 32) {
                invalid = true;
            }
            this.incPos(1);
        }
        int len = this.pos - headerNameStart;
        if (invalid) {
            throw new HttpRequestParseException("Header name '" + StringUtils.getString(this.buf, headerNameStart, len) + "' has a space character.", this);
        }
        this.updateAndValidateHeaderSizes(len);
        switch (len) {
            case 4: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.HOST_HEADER_BYTES)) break;
                return "Host";
            }
            case 6: {
                if (this.cmp(this.buf, headerNameStart, HttpConstants.COOKIE_HEADER_BYTES)) {
                    return "Cookie";
                }
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.EXPECT_HEADER_BYTES)) break;
                return "Expect";
            }
            case 7: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.TRAILER_HEADER_BYTES)) break;
                return "Trailer";
            }
            case 9: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.AUTH_TYPE_HEADER_BYTES)) break;
                return "AUTH_TYPE";
            }
            case 10: {
                if (this.cmp(this.buf, headerNameStart, HttpConstants.CONNECTION_HEADER_BYTES)) {
                    return "Connection";
                }
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.USER_AGENT_HEADER_BYTES)) break;
                return "User-Agent";
            }
            case 12: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.CONTENT_TYPE_HEADER_BYTES)) break;
                return "Content-Type";
            }
            case 13: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.AUTHORIZATION_HEADER_BYTES)) break;
                return "Authorization";
            }
            case 14: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.CONTENT_LENGTH_HEADER_BYTES)) break;
                return "Content-Length";
            }
            case 17: {
                if (!this.cmp(this.buf, headerNameStart, HttpConstants.TRANSFER_ENCODING_HEADER_BYTES)) break;
                return "Transfer-Encoding";
            }
        }
        return StringUtils.getString(this.buf, headerNameStart, len);
    }

    private void headerColon() throws HttpRequestParseException {
        this.consumeSpaces();
        if (this.buf[this.pos++] != 58) {
            throw new HttpRequestParseException("Expected : after header name but found " + (char)this.buf[this.pos - 1], this);
        }
        this.consumeSpaces();
    }

    private byte[] headerValue() throws HttpRequestParseException {
        int mark;
        int mark2;
        block0: while (true) {
            mark2 = this.pos;
            if (this.isCRLF()) {
                this.crlf();
            }
            if (!this.isSpaceTab()) break;
            while (true) {
                if (!this.isSpaceTab()) continue block0;
                this.incPos(1);
            }
            break;
        }
        this.pos = mark2;
        int headerValueStart = this.pos;
        int foldedLineChars = 0;
        while (true) {
            if (!this.isCRLF()) {
                this.incPos(1);
                continue;
            }
            mark = this.pos;
            int skip = this.crlf();
            if (!this.isSpaceTab()) break;
            while (this.isSpaceTab(this.buf[this.pos + 1])) {
                this.incPos(1);
                ++skip;
            }
            foldedLineChars += skip;
        }
        this.pos = mark;
        if (foldedLineChars == 0) {
            this.updateAndValidateHeaderSizes(this.pos - headerValueStart);
            return byteBufferCache.getByteBuffer(this.buf, headerValueStart, this.pos - headerValueStart);
        }
        int hvLen = this.pos - headerValueStart - foldedLineChars;
        this.updateAndValidateHeaderSizes(hvLen);
        byte[] hv = new byte[hvLen];
        int j = 0;
        for (int i = headerValueStart; i < this.pos; ++i) {
            if (this.isCR(this.buf[i]) && this.isLF(this.buf[i + 1]) && this.isSpaceTab(this.buf[i + 2]) || this.isLF(this.buf[i]) && this.isCR(this.buf[i + 1]) && this.isSpaceTab(this.buf[i + 2])) {
                ++i;
                while (this.isSpaceTab(this.buf[i + 2])) {
                    ++i;
                }
                continue;
            }
            if (this.isLF(this.buf[i]) && this.isSpaceTab(this.buf[i + 1])) {
                while (this.isSpaceTab(this.buf[i + 2])) {
                    ++i;
                }
                continue;
            }
            hv[j++] = this.buf[i];
        }
        return hv;
    }

    private void updateAndValidateHeaderSizes(int lengthOfParsedItem) throws HttpRequestParseException {
        this.totalHeadersSize += lengthOfParsedItem;
        this.singleHeaderSize += lengthOfParsedItem;
        boolean totalHeadersSizeExceeded = false;
        boolean singleHeaderSizeExceeded = false;
        if (this.maxTotalHeadersSize >= 0 && this.totalHeadersSize > this.maxTotalHeadersSize) {
            totalHeadersSizeExceeded = true;
        }
        if (this.maxSingleHeaderSize >= 0 && this.singleHeaderSize > this.maxSingleHeaderSize) {
            singleHeaderSizeExceeded = true;
        }
        if (totalHeadersSizeExceeded || singleHeaderSizeExceeded) {
            throw HttpRequestParseException.maxHeaderSizeExceeded(singleHeaderSizeExceeded ? this.maxSingleHeaderSize : -1, totalHeadersSizeExceeded ? this.maxTotalHeadersSize : -1);
        }
    }

    static class ByteBufferCache {
        AtomicReferenceArray<byte[]>[] cache;
        volatile int nextToEvict;
        int maxBufferLen;
        int entryCount;
        private static final byte[] JSESSION_START_BYTES = "JSES".getBytes();

        ByteBufferCache(int maxBufferLen, int entryCount) {
            this.maxBufferLen = maxBufferLen;
            this.entryCount = entryCount;
            this.cache = new AtomicReferenceArray[maxBufferLen];
            for (int i = 0; i < maxBufferLen; ++i) {
                this.cache[i] = new AtomicReferenceArray(entryCount);
            }
        }

        byte[] getByteBuffer(byte[] buf, int pos, int length) {
            if (length >= this.maxBufferLen || this.isFiltered(buf, pos, length)) {
                byte[] result = new byte[length];
                System.arraycopy(buf, pos, result, 0, length);
                return result;
            }
            AtomicReferenceArray<byte[]> currentCachePos = this.cache[length];
            for (int entryOffset = 0; entryOffset < this.entryCount; ++entryOffset) {
                int j;
                byte[] currentEntry = currentCachePos.get(entryOffset);
                if (currentEntry == null) {
                    byte[] result = new byte[length];
                    System.arraycopy(buf, pos, result, 0, length);
                    currentCachePos.set(entryOffset, result);
                    return result;
                }
                for (j = length - 1; j >= 0 && buf[pos + j] == currentEntry[j]; --j) {
                }
                if (j != -1) continue;
                return currentEntry;
            }
            byte[] result = new byte[length];
            System.arraycopy(buf, pos, result, 0, length);
            int evictee = this.nextToEvict++;
            if (evictee >= this.entryCount) {
                evictee = 0;
                this.nextToEvict = 0;
            }
            currentCachePos.set(evictee, result);
            return result;
        }

        private boolean isFiltered(byte[] buf, int pos, int length) {
            return length > 24 && JSESSION_START_BYTES[0] == buf[pos] && JSESSION_START_BYTES[1] == buf[pos + 1] && JSESSION_START_BYTES[2] == buf[pos + 2] && JSESSION_START_BYTES[3] == buf[pos + 3];
        }
    }
}

