/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.http.MaxRequestParameterExceedException;

public final class QueryParams
implements Serializable,
Map,
Cloneable {
    static final long serialVersionUID = -5069090774594903108L;
    private transient int maxParameters = 10000;
    private static boolean useArrayMap = Boolean.getBoolean("weblogic.utils.http.requestparams.useArrayMap");
    private final Map params = this.createMap();

    private Map createMap() {
        if (useArrayMap) {
            return new ArrayMap(4);
        }
        return new TreeMap();
    }

    public QueryParams() {
    }

    public QueryParams(int limit) {
        this.maxParameters = limit;
    }

    public void setLimit(int limit) {
        this.maxParameters = limit;
    }

    private ArrayList getCurrentAndCheck(Object key) {
        ArrayList current = (ArrayList)this.params.get(key);
        if (current == null) {
            current = new ArrayList(2);
            this.params.put(key, current);
        }
        this.checkLimit();
        return current;
    }

    private void checkLimit() {
        if (this.maxParameters != -1 && this.params.size() > this.maxParameters) {
            throw new MaxRequestParameterExceedException();
        }
    }

    public Object prepend(Object key, Object value) {
        ArrayList current = this.getCurrentAndCheck(key);
        current.add(0, value);
        if (current.size() > 2) {
            return current.get(1);
        }
        return null;
    }

    public Object append(Object key, Object value) {
        ArrayList current = this.getCurrentAndCheck(key);
        current.add(value);
        if (current.size() > 1) {
            return current.get(current.size() - 1);
        }
        return null;
    }

    public Object put(Object key, Object value) {
        ArrayList current = this.getCurrentAndCheck(key);
        current.add(value);
        if (current.size() > 1) {
            return current.get(0);
        }
        return null;
    }

    public String getValue(Object key) {
        String[] vals = this.getValues(key);
        if (vals != null) {
            return vals[0];
        }
        return null;
    }

    public String[] getValues(Object key) {
        try {
            ArrayList current = (ArrayList)this.params.get(key);
            if (current == null) {
                return null;
            }
            String[] vals = new String[current.size()];
            return current.toArray(vals);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public Object get(Object key) {
        return StringUtils.join(this.getValues(key), ",");
    }

    public Object clone() {
        QueryParams copy = new QueryParams(this.maxParameters);
        for (Object key : this.params.keySet()) {
            ArrayList listCopy = new ArrayList(this.getCurrentAndCheck(key));
            copy.params.put(key, listCopy);
        }
        return copy;
    }

    protected void putArrayList(String key, ArrayList list) {
        this.params.put(key, list);
        this.checkLimit();
    }

    public String toString() {
        return this.params.toString();
    }

    @Override
    public void clear() {
        this.params.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.params.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.params.containsValue(value);
    }

    public Set entrySet() {
        return this.params.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof QueryParams) {
            return this.params.equals(((QueryParams)obj).params);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.params.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Set keySet() {
        return this.params.keySet();
    }

    public void putAll(Map map) {
        this.params.putAll(map);
        this.checkLimit();
    }

    public Object remove(Object key) {
        return this.params.remove(key);
    }

    @Override
    public int size() {
        return this.params.size();
    }

    public Collection values() {
        return this.params.values();
    }
}

