/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.utils.http.HttpRequestParseException;

public interface RequestParser {
    public void initFromRequstParser(RequestParser var1);

    public void parse(byte[] var1, int var2) throws HttpRequestParseException;

    public void parse(byte[] var1, int var2, int var3, int var4) throws HttpRequestParseException;

    public void reset();

    public String getProtocol();

    public String getMethod();

    public String getScheme();

    public String getRequestURI();

    public String getNormalizedURI();

    public List<String> getPathParameters();

    public ArrayList getHeaderNames();

    public ArrayList getHeaderValues();

    public byte[] getHeader(String var1);

    public boolean isKeepAlive();

    public byte[] getHttpRequestBuffer();

    public int getQueryStringStart();

    public int getQueryStringLength();

    public ByteBuffer getOriginalRequestUriBytes();

    public Map<String, String> getTrailers();

    public void addTrailerField(String var1, String var2);

    public void markTrailerFieldsReady();

    public boolean isTrailerFieldsReady();

    public void setMethod(String var1);

    public void setScheme(String var1);

    public void addHeader(String var1, byte[] var2);

    default public boolean isMethodSafe() {
        return this.isMethodGet() || this.isMethodHead();
    }

    default public boolean isMethodWithoutEntityBody() {
        return this.isMethodGet() || this.isMethodHead() || this.isMethodDelete();
    }

    default public boolean isMethodDelete() {
        return "DELETE".equals(this.getMethod());
    }

    default public boolean isMethodGet() {
        return "GET".equals(this.getMethod());
    }

    default public boolean isMethodTrace() {
        return "TRACE".equals(this.getMethod());
    }

    default public boolean isMethodPost() {
        return "POST".equals(this.getMethod());
    }

    default public boolean isMethodHead() {
        return "HEAD".equals(this.getMethod());
    }

    default public boolean isMethodOptions() {
        return "OPTIONS".equals(this.getMethod());
    }

    default public boolean isProtocolVersion_1_1() {
        return "HTTP/1.1".equals(this.getProtocol());
    }

    default public boolean isProtocolVersion_2() {
        return "HTTP/2".equals(this.getProtocol());
    }
}

