/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.PartitionedConcurrentPool;
import weblogic.utils.collections.Pool;
import weblogic.utils.io.Chunk;

public final class BufferManager {
    private static boolean DEBUG = false;
    private static final int DEFAULT_PARTITION_SIZE = 4;
    private static final int DEFAULT_CHUNK_POOL_SIZE = 2048;
    private final Pool<Chunk> chunkPool = this.initializePool();

    public static BufferManager getInstance() {
        return Factory.THE_ONE;
    }

    private BufferManager() {
    }

    private Pool initializePool() {
        final int poolSize = this.getPoolSize();
        int partitionedSize = this.getPartitionSize();
        try {
            return new PartitionedConcurrentPool(poolSize, partitionedSize);
        }
        catch (ExceptionInInitializerError error) {
            return new Pool<Chunk>(){
                private final Chunk[] values;
                private int pointer;
                {
                    this.values = new Chunk[poolSize];
                    this.pointer = 0;
                }

                @Override
                public synchronized boolean add(Chunk o) {
                    if (this.pointer == this.values.length) {
                        return false;
                    }
                    this.values[this.pointer++] = o;
                    return true;
                }

                @Override
                public synchronized Chunk remove() {
                    if (this.pointer > 0) {
                        Chunk o = this.values[--this.pointer];
                        this.values[this.pointer] = null;
                        return o;
                    }
                    return null;
                }
            };
        }
    }

    private int getPartitionSize() {
        try {
            return Integer.getInteger("weblogic.PartitionSize", 4);
        }
        catch (SecurityException securityException) {
            return 4;
        }
    }

    private int getPoolSize() {
        Integer i = null;
        try {
            i = Integer.getInteger("weblogic.utils.io.chunkpoolsize");
            if (i == null) {
                i = Integer.getInteger("weblogic.utils.io.Chunk.PoolSize", 2048);
            }
            return i;
        }
        catch (SecurityException securityException) {
            return 2048;
        }
    }

    public Chunk getChunk() {
        Chunk c = this.chunkPool.remove();
        if (c != null) {
            c.setInUse();
        }
        return c;
    }

    public boolean releaseChunk(Chunk c) {
        String details = null;
        if (DEBUG) {
            details = "Thread:" + Thread.currentThread().getName() + "\n" + StackTraceUtils.throwable2StackTraceTruncated(new RuntimeException("releaseChunk"), 20);
        }
        if (c.release()) {
            c.setDetails(DEBUG ? details : null);
            return this.chunkPool.add(c);
        }
        if (DEBUG) {
            String oldDetails = c.getDetails();
            System.out.println("debugChunkPool: chunk released previously " + oldDetails + " \n and now " + details);
        }
        return false;
    }

    private static final class Factory {
        static final BufferManager THE_ONE = new BufferManager();

        private Factory() {
        }
    }
}

