/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import weblogic.utils.io.ByteBufferInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class ByteBufferDataInputStream
extends ByteBufferInputStream
implements DataInput,
StringInput {
    public ByteBufferDataInputStream(ByteBuffer[] buffers) {
        super(buffers);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        DataIO.readFully(this, b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        DataIO.readFully(this, b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return DataIO.skipBytes(this, n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return DataIO.readBoolean(this);
    }

    @Override
    public byte readByte() throws IOException {
        if (this.currentBuffer.remaining() >= 1) {
            return this.currentBuffer.get();
        }
        return DataIO.readByte(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return DataIO.readUnsignedByte(this);
    }

    @Override
    public short readShort() throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            return this.currentBuffer.getShort();
        }
        return DataIO.readShort(this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return DataIO.readUnsignedShort(this);
    }

    @Override
    public char readChar() throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            return this.currentBuffer.getChar();
        }
        return DataIO.readChar(this);
    }

    @Override
    public int readInt() throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            return this.currentBuffer.getInt();
        }
        return DataIO.readInt(this);
    }

    @Override
    public long readLong() throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            return this.currentBuffer.getLong();
        }
        return DataIO.readLong(this);
    }

    @Override
    public float readFloat() throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            return this.currentBuffer.getFloat();
        }
        return DataIO.readFloat(this);
    }

    @Override
    public double readDouble() throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            return this.currentBuffer.getDouble();
        }
        return DataIO.readDouble(this);
    }

    @Override
    public String readLine() throws IOException {
        return DataIO.readLine(this);
    }

    @Override
    public String readUTF() throws IOException {
        return DataIO.readUTF(this);
    }

    @Override
    public String readASCII() throws IOException {
        return DataIO.readASCII(this);
    }

    @Override
    public String readUTF8() throws IOException {
        return DataIO.readUTF8(this);
    }
}

