/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer currentBuffer;
    private ByteBuffer[] buffers;
    private int currentIndex;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this(new ByteBuffer[]{buffer});
    }

    public ByteBufferInputStream(ByteBuffer[] buffers) {
        this.buffers = buffers;
        this.currentIndex = 0;
        this.currentBuffer = buffers[this.currentIndex];
    }

    @Override
    public int read() throws IOException {
        do {
            if (this.currentBuffer.remaining() < 1) continue;
            return this.currentBuffer.get() & 0xFF;
        } while (this.advance());
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int copyLen;
        int requested = len;
        do {
            int remaining = this.currentBuffer.remaining();
            copyLen = Math.min(remaining, len);
            this.currentBuffer.get(buf, off, copyLen);
            off += copyLen;
        } while ((len -= copyLen) > 0 && this.advance());
        if (requested == len) {
            return -1;
        }
        return requested - len;
    }

    private final boolean advance() {
        if (++this.currentIndex < this.buffers.length) {
            this.currentBuffer = this.buffers[this.currentIndex];
            return true;
        }
        return false;
    }

    @Override
    public int available() throws IOException {
        int remainingBytes = 0;
        for (int i = this.currentIndex; i < this.buffers.length; ++i) {
            remainingBytes += this.buffers[i].remaining();
        }
        return remainingBytes;
    }
}

