/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    protected ByteBuffer currentBuffer;
    private ByteBuffer[] buffers;

    public ByteBufferOutputStream() {
        this(1024);
    }

    public ByteBufferOutputStream(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentBuffer = ByteBuffer.allocate(bufferSize);
        this.buffers = new ByteBuffer[]{this.currentBuffer};
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.currentBuffer.remaining() < 1) {
            this.expand();
        }
        this.currentBuffer.put((byte)b);
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        while (true) {
            int remaining = this.currentBuffer.remaining();
            int copyLen = Math.min(remaining, len);
            this.currentBuffer.put(b, off, copyLen);
            off += copyLen;
            if ((len -= copyLen) <= 0) break;
            this.expand();
        }
    }

    private final void expand() {
        ByteBuffer[] tmp = new ByteBuffer[this.buffers.length + 1];
        System.arraycopy(this.buffers, 0, tmp, 0, this.buffers.length);
        this.buffers = tmp;
        this.buffers[this.buffers.length - 1] = this.currentBuffer = ByteBuffer.allocate(this.bufferSize);
    }

    public void addReadOnlyBuffers(ByteBuffer[] add) throws IOException {
        this.currentBuffer.limit(this.currentBuffer.position());
        ByteBuffer[] tmp = new ByteBuffer[this.buffers.length + add.length + 1];
        System.arraycopy(this.buffers, 0, tmp, 0, this.buffers.length);
        System.arraycopy(add, 0, tmp, this.buffers.length, add.length);
        this.buffers = tmp;
        this.buffers[this.buffers.length - 1] = this.currentBuffer = ByteBuffer.allocate(this.bufferSize);
    }

    public ByteBuffer[] getBuffers() throws IOException {
        this.flush();
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].flip();
        }
        return this.buffers;
    }
}

