/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.Hex;
import weblogic.utils.io.BufferManager;

public final class Chunk {
    private static final int DEFAULT_CHUNK_SIZE = 4080;
    public static final int CHUNK_SIZE = Chunk.getChunkSize();
    private static final DebugCategory debugChunkStats = Debug.getCategory("weblogic.ChunkStats");
    boolean readOnlySharedBuf;
    public final byte[] buf;
    public int end;
    public Chunk next;
    private ByteBuffer byteBuf;
    private AtomicBoolean released = new AtomicBoolean(false);
    private volatile String details = null;

    private static int getChunkSize() {
        Integer i = null;
        try {
            i = Integer.getInteger("weblogic.Chunksize");
            if (i == null) {
                i = Integer.getInteger("weblogic.utils.io.Chunk.ChunkSize", 4080);
            }
            return i;
        }
        catch (SecurityException securityException) {
            return 4080;
        }
    }

    public static Chunk getChunk() {
        Chunk c = BufferManager.getInstance().getChunk();
        if (c == null) {
            c = new Chunk();
        } else if (debugChunkStats.isEnabled()) {
            Factory.THE_ONE.reusingExistingChunk.getAndIncrement();
        }
        return c;
    }

    public static void replaceStolenChunks(int count) {
        while (count > 0 && BufferManager.getInstance().releaseChunk(new Chunk())) {
            --count;
        }
    }

    public static void releaseChunk(Chunk c) {
        if (c.readOnlySharedBuf) {
            return;
        }
        c.end = 0;
        c.next = null;
        c.byteBuf.clear();
        if (debugChunkStats.isEnabled()) {
            if (BufferManager.getInstance().releaseChunk(c)) {
                Factory.THE_ONE.successfullyAddedChunkBackToPool.getAndIncrement();
            } else {
                Factory.THE_ONE.chunkWillBeGCed.getAndIncrement();
            }
        } else {
            BufferManager.getInstance().releaseChunk(c);
        }
    }

    public static void releaseChunks(Chunk c) {
        while (c != null) {
            Chunk tmp = c.next;
            Chunk.releaseChunk(c);
            c = tmp;
        }
    }

    public static void signalLowMemoryCondition() {
    }

    public static void clearLowMemoryCondition() {
    }

    public static int size(Chunk c) {
        Chunk slow = c;
        Chunk fast = c;
        int sz = 0;
        while (slow != null) {
            sz += slow.end;
            slow = slow.next;
            fast = fast != null && fast.next != null ? fast.next.next : null;
            if (slow == null || fast != slow) continue;
            throw new RuntimeException("Invalid chunk list");
        }
        return sz;
    }

    public static Chunk tail(Chunk c) {
        Chunk tmp = c;
        while (tmp.next != null) {
            tmp = tmp.next;
        }
        return tmp;
    }

    public static Chunk ensureCapacity(Chunk c) {
        if (CHUNK_SIZE == c.end) {
            c.next = Chunk.getChunk();
            return c.next;
        }
        return c;
    }

    public static int chunkFully(Chunk c, InputStream in) throws IOException {
        Chunk tail = Chunk.tail(c);
        int totalRead = 0;
        while (true) {
            tail = Chunk.ensureCapacity(tail);
            int read = in.read(tail.buf, tail.end, CHUNK_SIZE - tail.end);
            if (read == -1) break;
            tail.end += read;
            totalRead += read;
        }
        return totalRead;
    }

    public static int chunk(Chunk c, InputStream in, int len) throws IOException {
        Chunk tail = Chunk.tail(c);
        int requested = len;
        while (len > 0) {
            tail = Chunk.ensureCapacity(tail);
            int toRead = Math.min(len, CHUNK_SIZE - tail.end);
            int read = in.read(tail.buf, tail.end, toRead);
            if (read == -1) {
                return requested - len;
            }
            tail.end += read;
            len -= read;
        }
        return requested;
    }

    public static Chunk split(Chunk c, int len) {
        Chunk newHead;
        int haveBytes = 0;
        while (haveBytes < len) {
            if ((haveBytes += c.end) >= len) continue;
            c = c.next;
        }
        int overShoot = haveBytes - len;
        if (overShoot == 0) {
            newHead = c.next;
        } else {
            newHead = Chunk.getChunk();
            System.arraycopy(c.buf, c.end - overShoot, newHead.buf, 0, overShoot);
            c.end -= overShoot;
            newHead.end = overShoot;
            newHead.next = c.next;
        }
        c.next = null;
        return newHead;
    }

    private Chunk() {
        this(new byte[CHUNK_SIZE], 0);
        if (debugChunkStats.isEnabled()) {
            long i = Factory.THE_ONE.createdNewChunk.getAndIncrement();
            if (i % 1024L == 0L) {
                Factory.THE_ONE.dumpStats();
            }
        }
    }

    public Chunk(int size) {
        this(new byte[size], 0);
    }

    private Chunk(byte[] buf, int end) {
        this.buf = buf;
        this.end = end;
        this.next = null;
        this.byteBuf = ByteBuffer.wrap(buf);
    }

    public String toString() {
        return super.toString() + " - end: '" + this.end + "', buf: '" + Hex.dump(this.buf) + "', next: '" + this.next + "'";
    }

    public ByteBuffer getReadByteBuffer() {
        this.byteBuf.limit(this.byteBuf.capacity());
        this.byteBuf.position(this.end);
        return this.byteBuf;
    }

    public ByteBuffer getWriteByteBuffer() {
        this.byteBuf.position(0);
        this.byteBuf.limit(this.end);
        return this.byteBuf;
    }

    public ByteBuffer wrapAsReadOnlyByteBuffer() {
        this.readOnlySharedBuf = true;
        ByteBuffer bb = ByteBuffer.wrap(this.buf, 0, this.end).asReadOnlyBuffer();
        return bb;
    }

    public boolean isReadOnlySharedBuf() {
        return this.readOnlySharedBuf;
    }

    public static Chunk createSharedChunk(byte[] buf, int end) {
        Chunk created = new Chunk(buf, end);
        created.readOnlySharedBuf = true;
        return created;
    }

    public Chunk createOneSharedChunk() {
        if (!this.readOnlySharedBuf && this.buf.length == CHUNK_SIZE) {
            Chunk.replaceStolenChunks(1);
        }
        Chunk created = new Chunk(this.buf, this.end);
        this.readOnlySharedBuf = true;
        created.readOnlySharedBuf = true;
        return created;
    }

    public static Chunk createOneSharedChunk(InputStream inputStream, int len) throws IOException {
        int count;
        byte[] custom = new byte[len];
        for (int n = 0; n < len; n += count) {
            count = inputStream.read(custom, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        Chunk chunk = new Chunk(custom, len);
        chunk.readOnlySharedBuf = true;
        return chunk;
    }

    public Chunk getSharedBeforeTailCopy(Chunk tail) {
        Chunk partTwo;
        Chunk firstShared = null;
        Chunk lastShared = null;
        Chunk current = this;
        while (current != tail && current.next != null) {
            if (current.end == 0) {
                current = current.next;
                continue;
            }
            Chunk share = current.createOneSharedChunk();
            if (lastShared == null) {
                firstShared = share;
            } else {
                lastShared.next = share;
            }
            lastShared = share;
            current = current.next;
        }
        if (current.end <= CHUNK_SIZE) {
            partTwo = Chunk.getChunk();
            partTwo.end = current.end;
            System.arraycopy(current.buf, 0, partTwo.buf, 0, partTwo.end);
        } else {
            if (!current.readOnlySharedBuf && current.next == null) {
                current.next = Chunk.getChunk();
            }
            partTwo = current.createOneSharedChunk();
            partTwo.next = Chunk.getChunk();
        }
        if (firstShared == null) {
            return partTwo;
        }
        lastShared.next = partTwo;
        return firstShared;
    }

    public int setShareBuffer() {
        Chunk current = this;
        int count = 0;
        while (true) {
            if (!current.readOnlySharedBuf) {
                current.readOnlySharedBuf = true;
                ++count;
            }
            if (current.next == null) {
                return count;
            }
            current = current.next;
        }
    }

    public boolean setInUse() {
        return this.released.compareAndSet(true, false);
    }

    public boolean release() {
        return this.released.compareAndSet(false, true);
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    private static final class Stats {
        public static final int DUMP_STATS_AFTER_EVERY_1024_NEW_CHUNKS_ARE_CREATED = 1024;
        AtomicLong createdNewChunk = new AtomicLong();
        AtomicLong successfullyAddedChunkBackToPool = new AtomicLong();
        AtomicLong reusingExistingChunk = new AtomicLong();
        AtomicLong chunkWillBeGCed = new AtomicLong();

        private Stats() {
        }

        void dumpStats() {
            Debug.say("<ChunkStats> <" + System.currentTimeMillis() + "> Chunk Pool Stats: Cumulative New chunks created so far: " + this.createdNewChunk.get() + "; No. of times chunk added back to pool: " + this.successfullyAddedChunkBackToPool.get() + "; No. of times chunk found in pool: " + this.reusingExistingChunk.get() + "; No. of times chunk could not be added to pool: " + this.chunkWillBeGCed.get());
        }
    }

    private static final class Factory {
        static final Stats THE_ONE = new Stats();

        private Factory() {
        }
    }
}

