/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.Hex;
import weblogic.utils.io.Chunk;

public class ChunkedInputStream
extends InputStream {
    protected Chunk head;
    private Chunk markHead;
    protected int streamPos;
    private int markStreamPos;
    protected int chunkPos;
    private int markChunkPos;
    private InputStream is;

    protected ChunkedInputStream() {
    }

    public ChunkedInputStream(Chunk h, int skip, InputStream backingStream) throws IOException {
        this.is = backingStream;
        this.head = h;
        this.skip(skip);
    }

    public ChunkedInputStream(Chunk h, int skip) {
        this.init(h, skip);
    }

    public final Chunk getChunks() {
        return this.head;
    }

    public final int getChunkPos() {
        return this.chunkPos;
    }

    public void init(Chunk head, int skip) {
        this.head = head;
        this.markHead = null;
        this.streamPos = 0;
        this.chunkPos = 0;
        this.markStreamPos = -1;
        this.markChunkPos = -1;
        this.is = null;
        try {
            this.skip(skip);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public String dumpBuf(int skip) {
        StringBuffer buf = new StringBuffer(Hex.dump(this.head.buf, this.chunkPos + skip, this.head.end - this.chunkPos - skip));
        Chunk tmp = this.head.next;
        while (tmp != null) {
            buf.append("\n").append(Hex.dump(tmp.buf, 0, tmp.end));
            tmp = tmp.next;
        }
        return buf.toString();
    }

    protected final void advanceList() {
        this.streamPos += this.head.end;
        this.chunkPos = 0;
        Chunk tmp = this.head.next;
        if (this.markHead == null) {
            Chunk.releaseChunk(this.head);
        }
        this.head = tmp;
    }

    @Override
    public int available() {
        int availBytes = this.head.end - this.chunkPos;
        Chunk tmp = this.head;
        while (tmp.next != null) {
            tmp = tmp.next;
            availBytes += tmp.end;
        }
        return availBytes;
    }

    @Override
    public void close() {
        if (this.markHead != null) {
            this.reset();
        }
        while (this.head != null) {
            this.advanceList();
        }
    }

    public final boolean isMarked() {
        return this.markHead != null;
    }

    @Override
    public final void mark(int readLimit) {
        this.markStreamPos = this.streamPos;
        this.markChunkPos = this.chunkPos;
        this.markHead = this.head;
    }

    @Override
    public final boolean markSupported() {
        return this.is == null;
    }

    @Override
    public int read() throws IOException {
        while (this.chunkPos == this.head.end) {
            if (this.head.next != null) {
                this.advanceList();
                continue;
            }
            if (this.is != null) {
                return this.is.read();
            }
            return -1;
        }
        return this.head.buf[this.chunkPos++] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int requested = len;
        while (len > 0) {
            if (this.chunkPos == this.head.end) {
                if (this.head.next != null) {
                    this.advanceList();
                } else {
                    if (this.is != null) {
                        return requested - len + this.is.read(buf, off, len);
                    }
                    if (len == requested) {
                        return -1;
                    }
                    return requested - len;
                }
            }
            int copyLen = Math.min(this.head.end - this.chunkPos, len);
            System.arraycopy(this.head.buf, this.chunkPos, buf, off, copyLen);
            this.chunkPos += copyLen;
            off += copyLen;
            len -= copyLen;
        }
        return requested;
    }

    @Override
    public final void reset() {
        this.streamPos = this.markStreamPos;
        this.chunkPos = this.markChunkPos;
        this.head = this.markHead;
        this.markChunkPos = -1;
        this.markHead = null;
        this.markStreamPos = -1;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        long requested = toSkip;
        while (toSkip > 0L) {
            if (this.chunkPos == this.head.end) {
                if (this.head.next != null) {
                    this.advanceList();
                } else {
                    if (this.is != null) {
                        return requested - toSkip + this.is.skip(toSkip);
                    }
                    return requested - toSkip;
                }
            }
            long skipLen = Math.min((long)(this.head.end - this.chunkPos), toSkip);
            this.chunkPos = (int)((long)this.chunkPos + skipLen);
            toSkip -= skipLen;
        }
        return requested;
    }

    public final int peek() {
        return this.peek(0);
    }

    public final int peek(int peekpos) {
        if (this.chunkPos + peekpos < this.head.end) {
            byte ret = this.head.buf[this.chunkPos + peekpos];
            return ret & 0xFF;
        }
        int off = this.head.end - this.chunkPos;
        Chunk tmp = this.head.next;
        while (tmp != null) {
            if (peekpos - off < tmp.end) {
                byte ret = tmp.buf[peekpos - off];
                return ret & 0xFF;
            }
            off += tmp.end;
            tmp = tmp.next;
        }
        return -1;
    }

    public final int pos() {
        return this.streamPos + this.chunkPos;
    }

    public String toString() {
        return super.toString() + " - currentPos: '" + this.pos() + ", chunkPos: '" + this.chunkPos + "', currentChunk: '" + this.head + "'";
    }
}

