/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.ObjectStreamClass;
import weblogic.utils.io.Resolver;

public final class ClassLoaderResolver
implements Resolver {
    private final ClassLoader loader;

    public ClassLoaderResolver(ClassLoader l) {
        this.loader = l;
    }

    @Override
    public Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        try {
            if (this.loader != null) {
                return Class.forName(osc.getName(), false, this.loader);
            }
            return Class.forName(osc.getName());
        }
        catch (ClassNotFoundException cnfe) {
            return Resolver.NOT_FOUND;
        }
    }
}

