/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.File;
import java.io.IOException;
import weblogic.utils.StringUtils;
import weblogic.utils.UnsyncStringBuffer;

public final class FilenameEncoder {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static String OS_NAME = null;
    private static boolean windowsOS = false;
    private static String USER_DIR = null;
    private static final char[] LEGAL_FILE_CHARS;
    private static final char SPECIAL = 'Z';

    public static String encode(String in) {
        return FilenameEncoder.encode(in.getBytes());
    }

    public static String encode(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        buf.append((char)(90 - bytes.length % 5));
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int j;
            long v = 0L;
            for (j = 4; j >= 0; --j) {
                v |= i < len ? ((long)bytes[i++] & 0xFFL) << 8 * j : 0L;
            }
            for (j = 7; j >= 0; --j) {
                int idx = (int)(v >> 5 * j & 0x1FL);
                buf.append(LEGAL_FILE_CHARS[idx]);
            }
        }
        return buf.toString();
    }

    public static byte[] decode(String str) {
        char[] chars = str.toCharArray();
        int b = 0;
        int extra = 90 - chars[0];
        int dataChars = chars.length - 1;
        int numBytes = extra == 0 ? dataChars / 8 * 5 : dataChars / 8 * 5 - (5 - extra);
        byte[] bytes = new byte[numBytes];
        int i = 1;
        int len = chars.length;
        while (i < len) {
            int j;
            long v = 0L;
            for (j = 7; j >= 0; --j) {
                int idx = FilenameEncoder.reverseMap(chars[i++]);
                v |= ((long)idx & 0x1FL) << 5 * j;
            }
            for (j = 4; j >= 0 && b < bytes.length; --j) {
                bytes[b++] = (byte)(v >> 8 * j);
            }
        }
        return bytes;
    }

    private static int reverseMap(char c) {
        if (c < 'A') {
            return c - 48;
        }
        return c - 65 + 10;
    }

    private static boolean isLegalChar(char c) {
        return true;
    }

    public static File getSafeFile(String parent, String child) throws IOException, UnsafeFilenameException {
        int childLength = child.length();
        for (int i = 0; i < childLength; ++i) {
            char c = child.charAt(i);
            if (c < '!') {
                return FilenameEncoder.getSafeFile0(parent, child);
            }
            if (c != '.' || i != childLength - 1 && child.charAt(i + 1) != '.') continue;
            return FilenameEncoder.getSafeFile0(parent, child);
        }
        return new File(parent, child);
    }

    public static File getSafeFile0(String parent, String child) throws IOException, UnsafeFilenameException {
        char last;
        if (parent.indexOf("..") != -1) {
            parent = FilenameEncoder.resolveRelativeFilePath(parent);
        }
        String slash = File.separator;
        UnsyncStringBuffer realPath = new UnsyncStringBuffer(parent);
        if (parent.endsWith(slash)) {
            if (child.startsWith(slash)) {
                realPath.append(child.substring(1));
            } else {
                realPath.append(child);
            }
        } else if (child.startsWith(slash)) {
            realPath.append(child);
        } else {
            realPath.append(slash).append(child);
        }
        String filePath = realPath.toString();
        File f = null;
        if (filePath.indexOf(0) != -1) {
            throw new UnsafeFilenameException("Filename contains illegal NULL-character \\u0000");
        }
        if (!windowsOS && filePath.startsWith("~")) {
            f = new File(filePath);
            File p = new File(parent);
            filePath = f.getCanonicalPath();
            if (!filePath.startsWith(p.getCanonicalPath())) {
                throw new UnsafeFilenameException(filePath + " not under: " + parent);
            }
        }
        if (((last = filePath.charAt(filePath.length() - 1)) < '!' || last == '.') && windowsOS) {
            throw new UnsafeFilenameException(filePath + " ends with illegal character");
        }
        if (filePath.indexOf("..") != -1 && !(filePath = FilenameEncoder.resolveRelativeFilePath(filePath)).startsWith(parent)) {
            throw new UnsafeFilenameException(filePath + " not under: " + parent);
        }
        return new File(filePath);
    }

    public static String resolveRelativeURIPath(String uriPath) {
        return FilenameEncoder.resolveRelativeURIPath(uriPath, false);
    }

    public static String resolveRelativeURIPath(String uriPath, boolean strictCheck) {
        return FilenameEncoder.resolveRelativePath(uriPath, '/', strictCheck);
    }

    public static String resolveRelativeFilePath(String uriPath) {
        return FilenameEncoder.resolveRelativePath(uriPath, File.separatorChar, false);
    }

    private static String resolveRelativePath(String filePath, char slash, boolean strictCheck) {
        int len = filePath.length();
        for (int i = 0; i < len; ++i) {
            char c = filePath.charAt(i);
            if (c != slash) continue;
            if (i == len - 1) break;
            c = filePath.charAt(i + 1);
            if (c != slash && c != '.') continue;
            return FilenameEncoder.resolveRelativePath0(filePath, slash, strictCheck);
        }
        return filePath;
    }

    private static String resolveRelativePath0(String filePath, char slash, boolean strictCheck) {
        int len = filePath.length();
        char[] ca = new char[len];
        int i = 0;
        int cai = 0;
        while (i < len) {
            if (i + 1 < len && filePath.charAt(i) == slash) {
                if (filePath.charAt(i + 1) == '.') {
                    if (i + 2 >= len) {
                        ca[cai++] = filePath.charAt(i);
                        break;
                    }
                    if (filePath.charAt(i + 2) == slash) {
                        i += 2;
                        continue;
                    }
                    if (i + 2 < len && filePath.charAt(i + 2) == '.' && (i + 3 >= len || filePath.charAt(i + 3) == slash)) {
                        int last_slash;
                        for (last_slash = cai - 1; last_slash > -1 && ca[last_slash] == slash; --last_slash) {
                        }
                        while (last_slash > -1 && ca[last_slash] != slash) {
                            --last_slash;
                        }
                        if (last_slash > -1) {
                            cai = last_slash;
                        } else {
                            if (strictCheck) {
                                return null;
                            }
                            ca[0] = slash;
                            cai = 1;
                        }
                        i += 3;
                        continue;
                    }
                } else if (filePath.charAt(i + 1) == slash && (i == 0 || filePath.charAt(i - 1) != ':')) {
                    ++i;
                    continue;
                }
            }
            ca[cai++] = filePath.charAt(i++);
        }
        try {
            filePath = new String(ca, 0, cai);
        }
        catch (StringIndexOutOfBoundsException e) {
            filePath = "";
        }
        return filePath;
    }

    public static String cleanClasspath(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        s = s.replace('/', File.separatorChar);
        String[] strgs = StringUtils.splitCompletely(s, File.pathSeparator, false);
        StringBuilder sb = new StringBuilder(s.length());
        int length = strgs.length;
        for (int i = 0; i < length; ++i) {
            boolean dup = true;
            if (strgs[i].startsWith("." + File.separatorChar) || strgs[i].startsWith(".." + File.separatorChar)) {
                strgs[i] = USER_DIR + File.separatorChar + strgs[i];
            }
            strgs[i] = FilenameEncoder.resolveRelativeFilePath(strgs[i]);
            String ithString = strgs[i];
            for (int j = 0; j < i; ++j) {
                if (!ithString.equals(strgs[j])) continue;
                dup = false;
                break;
            }
            if (!dup) continue;
            sb.append(ithString).append(File.pathSeparator);
        }
        return sb.toString();
    }

    static {
        if (OS_NAME == null && (OS_NAME = System.getProperty("os.name")) == null) {
            OS_NAME = "null";
        }
        if (OS_NAME.startsWith("Windows")) {
            windowsOS = true;
        }
        USER_DIR = System.getProperty("user.dir");
        LEGAL_FILE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    }

    public static class UnsafeFilenameException
    extends Exception {
        private static final long serialVersionUID = -244946124352757151L;

        public UnsafeFilenameException(String s) {
            super(s);
        }
    }
}

