/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import weblogic.utils.io.ExceptionClassReplacer;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;

public class FilteringObjectInputStream
extends ObjectInputStream {
    private volatile Class<?> expectedType;
    private volatile Class<?>[] expectedTypes;
    private boolean setFilter = false;

    protected FilteringObjectInputStream() throws IOException {
        this.setFilter = true;
        WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
    }

    public FilteringObjectInputStream(InputStream is) throws IOException {
        super(is);
        WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
    }

    protected FilteringObjectInputStream(InputStream is, boolean setFilter) throws IOException {
        super(is);
        if (setFilter) {
            this.setFilter = true;
            WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
        }
    }

    protected void resetMTLFilter() {
        WebLogicObjectInputFilter.resetMTLFilter(this);
    }

    protected FilteringObjectInputStream(InputStream is, boolean setFilter, boolean isTrusted) throws IOException {
        super(is);
        if (setFilter && isTrusted) {
            this.setFilter = true;
            WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
        }
    }

    protected FilteringObjectInputStream(InputStream is, boolean setFilter, boolean isTrusted, String allowListViolationAction) throws IOException {
        super(is);
        if (allowListViolationAction != null) {
            WebLogicObjectInputFilter.setAllowListViolationAction(allowListViolationAction);
        }
        if (setFilter && isTrusted) {
            this.setFilter = true;
            WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass descriptor) throws ClassNotFoundException, IOException {
        this.checkLegacyBlacklistIfNeeded(descriptor.getName());
        String className = descriptor.getName();
        Class<?> cls = ExceptionClassReplacer.getReplacementClassIfAvailable(FilteringObjectInputStream.getThreadContextClassLoader(), className);
        if (cls == null) {
            cls = super.resolveClass(descriptor);
        }
        this.validateReturnType(cls);
        return cls;
    }

    private static ClassLoader getThreadContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected void checkLegacyBlacklistIfNeeded(String className) throws InvalidClassException {
        WebLogicObjectInputFilter.checkLegacyBlacklistIfNeeded(className);
    }

    public Object readObjectValidated(Class<?> returnType) throws IOException, ClassNotFoundException {
        try {
            this.expectedType = returnType;
            Object object = this.readObject();
            return object;
        }
        finally {
            this.expectedType = null;
        }
    }

    public Object readObjectValidated(Class<?>[] returnTypes) throws IOException, ClassNotFoundException {
        try {
            this.expectedTypes = returnTypes;
            Object object = this.readObject();
            return object;
        }
        finally {
            this.expectedTypes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateReturnType(Class<?> returnType) throws InvalidClassException {
        block10: {
            if (this.expectedType == null && this.expectedTypes == null) {
                return;
            }
            try {
                if (returnType == null) {
                    break block10;
                }
                if (this.expectedType != null) {
                    if (!this.expectedType.isAssignableFrom(returnType)) {
                        throw new InvalidClassException("Expected type of " + this.expectedType.getName() + " but actual type was " + returnType.getName());
                    }
                    break block10;
                }
                for (int i = 0; i < this.expectedTypes.length; ++i) {
                    if (!this.expectedTypes[i].isAssignableFrom(returnType)) continue;
                    return;
                }
                String classTypes = "[ ";
                for (int i = 0; i < this.expectedTypes.length; ++i) {
                    if (i <= 0) continue;
                    classTypes = classTypes + ", " + this.expectedTypes[i].getName();
                }
                classTypes = classTypes + "]";
                throw new InvalidClassException("Expected type of " + classTypes + " but actual type was " + returnType.getName());
            }
            finally {
                this.expectedType = null;
                this.expectedTypes = null;
            }
        }
    }
}

