/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.glassfish.pfl.basic.reflection.Bridge;
import sun.misc.Unsafe;
import weblogic.utils.collections.ConcurrentWeakHashMap;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamField;

public final class ObjectStreamClass {
    private static final Bridge BRIDGE = ObjectStreamClass.getBridge();
    private static final Unsafe UNSAFE = ObjectStreamClass.getUnsafe();
    private static final Map<Class<?>, WeakReference<ObjectStreamClass>> CACHE = new ConcurrentWeakHashMap();
    private final Class<? extends Serializable> theClass;
    private final MethodHandle readResolveMethod;
    private final MethodHandle writeReplaceMethod;
    private final MethodHandle readObjectMethod;
    private final MethodHandle writeObjectMethod;
    private final java.io.ObjectStreamClass osc;
    private final Constructor constructor;
    private final boolean customMarshaled;
    private final boolean externalizable;
    private final boolean array;
    private final ObjectStreamField[] serialFields;
    private ObjectStreamClass superclass;

    private ObjectStreamClass(Class<? extends Serializable> c) {
        Class<? extends Serializable> sc;
        if (!Serializable.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class must implement Serializable");
        }
        this.theClass = c;
        this.osc = java.io.ObjectStreamClass.lookup(this.theClass);
        this.writeObjectMethod = BRIDGE.writeObjectForSerialization(this.theClass);
        this.readObjectMethod = BRIDGE.readObjectForSerialization(this.theClass);
        this.readResolveMethod = BRIDGE.readResolveForSerialization(this.theClass);
        this.writeReplaceMethod = BRIDGE.writeReplaceForSerialization(this.theClass);
        this.array = this.theClass.isArray();
        this.externalizable = Externalizable.class.isAssignableFrom(this.theClass);
        if (this.externalizable) {
            this.constructor = BRIDGE.newConstructorForExternalization(this.theClass);
            this.serialFields = null;
        } else {
            this.constructor = BRIDGE.newConstructorForSerialization(this.theClass);
            this.serialFields = ObjectStreamClass.getSerialFields(this.osc);
        }
        if (!this.theClass.isArray() && (sc = this.theClass.getSuperclass()) != null && sc.getSuperclass() != null && Serializable.class.isAssignableFrom(sc)) {
            this.superclass = ObjectStreamClass.lookup(sc);
        }
        this.customMarshaled = this.getCustomMarshaled();
    }

    public static boolean supportsUnsafeSerialization() {
        return ObjectStreamClass.isBridgeSupported();
    }

    public static OptionalDataException newOptionalDataException(boolean end) {
        return ObjectStreamClass.getBridge().newOptionalDataExceptionForSerialization(end);
    }

    public Class forClass() {
        return this.theClass;
    }

    public java.io.ObjectStreamClass getObjectStreamClass() {
        return this.osc;
    }

    public ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    public <T> T newInstance() throws IOException {
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(new Object[0]);
            }
            if (this.externalizable) {
                return (T)this.theClass.newInstance();
            }
            throw new NotSerializableException("Externalizables must have a public no-arg constructor, Serializables must have a public or protected no-arg constructor in a non-Serializable base-class");
        }
        catch (IllegalAccessException | InstantiationException iae2) {
            throw (IOException)new NotSerializableException("Failed to construct " + this.forClass().getName()).initCause(iae2);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof IOException) {
                throw (IOException)ite.getTargetException();
            }
            throw (IOException)new NotSerializableException("Failed to construct " + this.forClass().getName()).initCause(ite.getTargetException());
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplaceMethod != null;
    }

    public Object writeReplace(Object obj) throws IOException {
        if (this.writeReplaceMethod == null) {
            return obj;
        }
        try {
            return this.writeReplaceMethod.invoke(obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to invoke writeReplace() on " + this.forClass().getName(), t);
        }
    }

    public Object readResolve(Object obj) throws IOException {
        if (this.readResolveMethod == null) {
            return obj;
        }
        try {
            return this.readResolveMethod.invoke(obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to invoke readResolve() on " + this.forClass().getName(), t);
        }
    }

    public boolean hasWriteObject() {
        return this.writeObjectMethod != null;
    }

    public void writeObject(Object obj, ObjectOutputStream out) throws IOException {
        if (this.writeObjectMethod == null) {
            throw new IOException("No writeObject method for: " + obj);
        }
        try {
            this.writeObjectMethod.invoke(obj, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to invoke writeObject() on " + this.forClass().getName(), t);
        }
    }

    public boolean hasReadObject() {
        return this.readObjectMethod != null;
    }

    public void readObject(Object obj, ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.readObjectMethod == null) {
            throw new IOException("No readObject() method for: " + obj);
        }
        try {
            this.readObjectMethod.invoke(obj, in);
        }
        catch (IOException | ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to invoke readObject() on " + this.forClass().getName(), t);
        }
    }

    public boolean isCustomMarshaled() {
        return this.customMarshaled;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ObjectStreamClass && this.equals((ObjectStreamClass)other);
    }

    private boolean equals(ObjectStreamClass other) {
        return this.osc.equals(other.osc);
    }

    public int hashCode() {
        return this.osc.hashCode();
    }

    public String toString() {
        return this.osc.toString();
    }

    public long getSerialVersionUID() {
        return this.osc.getSerialVersionUID();
    }

    public ObjectStreamField[] getFields() {
        return (ObjectStreamField[])this.serialFields.clone();
    }

    public void writeFields(Object obj, ObjectOutput out) throws IOException {
        block11: for (ObjectStreamField f : this.serialFields) {
            switch (f.getTypeCode()) {
                case 'Z': {
                    out.writeBoolean(BRIDGE.getBoolean(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'B': {
                    out.writeByte(BRIDGE.getByte(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'C': {
                    out.writeChar(BRIDGE.getChar(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'S': {
                    out.writeShort(BRIDGE.getShort(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'I': {
                    out.writeInt(BRIDGE.getInt(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'F': {
                    out.writeFloat(BRIDGE.getFloat(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'J': {
                    out.writeLong(BRIDGE.getLong(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'D': {
                    out.writeDouble(BRIDGE.getDouble(obj, f.getFieldOffset()));
                    continue block11;
                }
                case 'L': 
                case '[': {
                    out.writeObject(BRIDGE.getObject(obj, f.getFieldOffset()), f.getType());
                    continue block11;
                }
                default: {
                    throw new IOException("Bad typecode: " + f.getTypeCode());
                }
            }
        }
    }

    public void readFields(Object obj, ObjectInput in) throws IOException, ClassCastException, ClassNotFoundException {
        block11: for (int i = 0; i < this.serialFields.length; ++i) {
            ObjectStreamField f = this.serialFields[i];
            switch (f.getTypeCode()) {
                case 'Z': {
                    BRIDGE.putBoolean(obj, f.getFieldOffset(), in.readBoolean());
                    continue block11;
                }
                case 'B': {
                    BRIDGE.putByte(obj, f.getFieldOffset(), in.readByte());
                    continue block11;
                }
                case 'C': {
                    BRIDGE.putChar(obj, f.getFieldOffset(), in.readChar());
                    continue block11;
                }
                case 'S': {
                    BRIDGE.putShort(obj, f.getFieldOffset(), in.readShort());
                    continue block11;
                }
                case 'I': {
                    BRIDGE.putInt(obj, f.getFieldOffset(), in.readInt());
                    continue block11;
                }
                case 'F': {
                    BRIDGE.putFloat(obj, f.getFieldOffset(), in.readFloat());
                    continue block11;
                }
                case 'J': {
                    BRIDGE.putLong(obj, f.getFieldOffset(), in.readLong());
                    continue block11;
                }
                case 'D': {
                    BRIDGE.putDouble(obj, f.getFieldOffset(), in.readDouble());
                    continue block11;
                }
                case 'L': 
                case '[': {
                    Object val = in.readObject(f.getType());
                    if (val != null && !f.getType().isInstance(val)) {
                        if (this.isCompatibleWithFieldNum(i + 1, val)) {
                            BRIDGE.putObject(obj, f.getFieldOffset(), null);
                            f = this.serialFields[++i];
                        } else {
                            throw new ClassCastException("Stream corrupted: expecting: " + f.getType().getName() + ", received: " + val.getClass().getName());
                        }
                    }
                    BRIDGE.putObject(obj, f.getFieldOffset(), val);
                    continue block11;
                }
                default: {
                    throw new IOException("Bad typecode: " + f.getTypeCode());
                }
            }
        }
    }

    private boolean isCompatibleWithFieldNum(int i, Object val) {
        return i < this.serialFields.length && this.serialFields[i].getType().isInstance(val);
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    private boolean getCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable() || this.superclass != null && this.superclass.isCustomMarshaled();
    }

    public static ObjectStreamClass lookup(Class theClass) {
        ObjectStreamClass cinfo;
        if (theClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        WeakReference<ObjectStreamClass> value = CACHE.get(theClass);
        ObjectStreamClass objectStreamClass = cinfo = value == null ? null : (ObjectStreamClass)value.get();
        if (cinfo == null) {
            if (!Serializable.class.isAssignableFrom(theClass)) {
                return null;
            }
            cinfo = new ObjectStreamClass(theClass);
            CACHE.put(theClass, new WeakReference<ObjectStreamClass>(cinfo));
        }
        return cinfo;
    }

    private static Bridge getBridge() {
        return AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

            @Override
            public Bridge run() {
                return Bridge.get();
            }
        });
    }

    private static Unsafe getUnsafe() {
        try {
            String p = System.getProperty("weblogic.system.useUnsafeSerialization");
            if (p != null && p.equalsIgnoreCase("false")) {
                return null;
            }
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException | UnsatisfiedLinkError nsfe) {
            return null;
        }
    }

    private static ObjectStreamField[] getSerialFields(java.io.ObjectStreamClass osc) {
        java.io.ObjectStreamField[] fields = osc.getFields();
        ObjectStreamField[] osf = new ObjectStreamField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            osf[i] = ObjectStreamClass.toWlsObjectStreamField(osc, fields[i]);
        }
        return osf;
    }

    private static ObjectStreamField toWlsObjectStreamField(java.io.ObjectStreamClass osc, java.io.ObjectStreamField objectStreamField) {
        return new ObjectStreamField(objectStreamField, ObjectStreamClass.getObjectFieldOffset(osc, objectStreamField), ObjectStreamClass.getClassSignature(objectStreamField.getType()));
    }

    private static long getObjectFieldOffset(java.io.ObjectStreamClass osc, java.io.ObjectStreamField objectStreamField) {
        return ObjectStreamClass.getObjectFieldOffset(ObjectStreamClass.getField(osc.forClass(), objectStreamField.getName()));
    }

    private static Field getField(Class<?> aClass, String name) {
        try {
            return aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static long getObjectFieldOffset(Field f) {
        return f != null && ObjectStreamClass.isBridgeSupported() ? BRIDGE.objectFieldOffset(f) : -1L;
    }

    private static String getClassSignature(Class<?> cl) {
        if (cl.isPrimitive()) {
            return ObjectStreamClass.getPrimitiveSignature(cl);
        }
        return ObjectStreamClass.appendClassSignature(new StringBuilder(), cl).toString();
    }

    private static StringBuilder appendClassSignature(StringBuilder sbuf, Class<?> cl) {
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            sbuf.append(ObjectStreamClass.getPrimitiveSignature(cl));
        } else {
            sbuf.append('L').append(cl.getName().replace('.', '/')).append(';');
        }
        return sbuf;
    }

    private static String getPrimitiveSignature(Class<?> cl) {
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        throw new InternalError();
    }

    private static boolean isBridgeSupported() {
        return UNSAFE != null;
    }
}

