/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_SIZE = 32;
    protected byte[] buf;
    protected int count;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    protected final void resizeBuffer(int minsize) {
        byte[] newbuf = new byte[Math.max(this.buf.length << 1, minsize)];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        this.buf = newbuf;
    }

    @Override
    public final void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.resizeBuffer(newcount);
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.resizeBuffer(newcount);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public final void reset() {
        this.count = 0;
    }

    public final byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public byte[] toRawBytes() {
        return this.buf;
    }

    public final int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }
}

