/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.InputStream;
import java.io.Reader;

public final class XMLDeclaration {
    private String version = null;
    private String encoding = null;
    private String standalone = null;
    private static final int HEADER_START = 0;
    private static final int HEADER_STARTED = 1;
    private static final int HEADER_XML = 2;
    private static final int SCANNING = 3;
    private static final int IN_ATTRIBUTE = 4;
    private static final int IN_STRING_LITERAL = 5;

    public XMLDeclaration() {
    }

    public XMLDeclaration(InputStream is) {
        this();
        this.parse(is);
    }

    public String getVersion() {
        return this.version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public void parse(InputStream headerReader) {
        block23: {
            String VERSION = "version";
            String ENCODING = "encoding";
            String STANDALONE = "standalone";
            String XML = "xml";
            String literal = null;
            StringBuffer buffer = new StringBuffer();
            char startQuote = '\u0000';
            try {
                int input;
                int state = 0;
                block9: while ((input = headerReader.read()) >= 0) {
                    char c = (char)input;
                    switch (state) {
                        case 0: {
                            if (c == '<') {
                                state = 1;
                                break;
                            }
                            break block23;
                        }
                        case 1: {
                            if (c == '?') {
                                state = 2;
                                buffer.setLength(0);
                                break;
                            }
                            break block23;
                        }
                        case 2: {
                            String instruction;
                            if (Character.isLetter(c)) {
                                buffer.append(c);
                                break;
                            }
                            if (Character.isWhitespace(c) && "xml".equals(instruction = buffer.toString())) {
                                state = 3;
                                break;
                            }
                            break block23;
                        }
                        case 5: {
                            if (c == startQuote) {
                                state = 3;
                                String value = buffer.toString();
                                if ("version".equals(literal)) {
                                    this.version = value;
                                    literal = null;
                                }
                                if ("encoding".equals(literal)) {
                                    this.encoding = value;
                                    literal = null;
                                }
                                if (!"standalone".equals(literal)) continue block9;
                                this.standalone = value;
                                literal = null;
                                break block23;
                            }
                            buffer.append(c);
                            break;
                        }
                        case 4: {
                            String attribute;
                            if (Character.isLetter(c)) {
                                buffer.append(c);
                                break;
                            }
                            if (c == '=' || Character.isWhitespace(c)) {
                                state = 3;
                                attribute = buffer.toString();
                                if ("version".equals(attribute)) {
                                    literal = "version";
                                    break;
                                }
                                if ("encoding".equals(attribute)) {
                                    literal = "encoding";
                                    break;
                                }
                                if (!"standalone".equals(attribute)) continue block9;
                                literal = "standalone";
                                break;
                            }
                            break block23;
                        }
                        default: {
                            String attribute;
                            if (Character.isWhitespace(c)) continue block9;
                            if (c == '=') break;
                            if (Character.isLetter(c)) {
                                state = 4;
                                buffer.setLength(0);
                                buffer.append(c);
                                attribute = null;
                                break;
                            }
                            if (c == '\'' || c == '\"') {
                                state = 5;
                                startQuote = c;
                                buffer.setLength(0);
                                Object var7_12 = null;
                                break;
                            }
                            break block23;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void parse(Reader headerReader) {
        block23: {
            String VERSION = "version";
            String ENCODING = "encoding";
            String STANDALONE = "standalone";
            String XML = "xml";
            String literal = null;
            StringBuffer buffer = new StringBuffer();
            char startQuote = '\u0000';
            try {
                int input;
                int state = 0;
                block9: while ((input = headerReader.read()) >= 0) {
                    char c = (char)input;
                    switch (state) {
                        case 0: {
                            if (c == '<') {
                                state = 1;
                                break;
                            }
                            break block23;
                        }
                        case 1: {
                            if (c == '?') {
                                state = 2;
                                buffer.setLength(0);
                                break;
                            }
                            break block23;
                        }
                        case 2: {
                            String instruction;
                            if (Character.isLetter(c)) {
                                buffer.append(c);
                                break;
                            }
                            if (Character.isWhitespace(c) && "xml".equals(instruction = buffer.toString())) {
                                state = 3;
                                break;
                            }
                            break block23;
                        }
                        case 5: {
                            if (c == startQuote) {
                                state = 3;
                                String value = buffer.toString();
                                if ("version".equals(literal)) {
                                    this.version = value;
                                    literal = null;
                                }
                                if ("encoding".equals(literal)) {
                                    this.encoding = value;
                                    literal = null;
                                }
                                if (!"standalone".equals(literal)) continue block9;
                                this.standalone = value;
                                literal = null;
                                break block23;
                            }
                            buffer.append(c);
                            break;
                        }
                        case 4: {
                            String attribute;
                            if (Character.isLetter(c)) {
                                buffer.append(c);
                                break;
                            }
                            if (c == '=' || Character.isWhitespace(c)) {
                                state = 3;
                                attribute = buffer.toString();
                                if ("version".equals(attribute)) {
                                    literal = "version";
                                    break;
                                }
                                if ("encoding".equals(attribute)) {
                                    literal = "encoding";
                                    break;
                                }
                                if (!"standalone".equals(attribute)) continue block9;
                                literal = "standalone";
                                break;
                            }
                            break block23;
                        }
                        default: {
                            String attribute;
                            if (Character.isWhitespace(c)) continue block9;
                            if (c == '=') break;
                            if (Character.isLetter(c)) {
                                state = 4;
                                buffer.setLength(0);
                                buffer.append(c);
                                attribute = null;
                                break;
                            }
                            if (c == '\'' || c == '\"') {
                                state = 5;
                                startQuote = c;
                                buffer.setLength(0);
                                Object var7_12 = null;
                                break;
                            }
                            break block23;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

