/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.Properties;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.FileUtils;

public class FilterFileHelper {
    public static final String TMP_FILE_EXT = ".tmp";
    public static final String BACKUP_FILE_EXT = ".bak";
    private static final long LOCK_TIMEOUT_MILLIS = 30000L;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugAllowList");

    public static boolean checkSerialPropFileExists(String propFile) {
        File spropFile = new File(propFile);
        return spropFile.exists();
    }

    public static Properties loadProperties(String propFile) throws Exception {
        Properties prop = new Properties();
        FileInputStream propertyInputStream = null;
        FileLock spLock = null;
        File spFile = new File(propFile);
        try {
            propertyInputStream = new FileInputStream(spFile);
            spLock = FileUtils.getSharedFileLock(propertyInputStream.getChannel(), 30000L);
            if (spLock == null) {
                throw new IOException("Unable to get lock on file " + spFile.getPath());
            }
        }
        catch (Exception ioe) {
            // empty catch block
        }
        try {
            if (propertyInputStream != null) {
                prop.load(propertyInputStream);
            } else {
                prop = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while loading " + propFile, ex);
        }
        finally {
            block20: {
                try {
                    if (spLock != null) {
                        spLock.release();
                    }
                    if (propertyInputStream != null) {
                        propertyInputStream.close();
                    }
                }
                catch (IOException ignore) {
                    if (!debugLogger.isDebugEnabled()) break block20;
                    debugLogger.debug("Exception during closing lock " + ignore.getMessage());
                }
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("loadProperties path is " + propFile);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCheckSum(String path) {
        long versionNumber = 0L;
        FilterInputStream cis = null;
        FileLock spLock = null;
        FileInputStream fileInputStream = null;
        try {
            File spFile = new File(path);
            if (!spFile.exists()) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("File path " + path + " and checksum is " + versionNumber);
                }
                long l = versionNumber;
                return l;
            }
            fileInputStream = new FileInputStream(path);
            spLock = FileUtils.getSharedFileLock(fileInputStream.getChannel(), 30000L);
            if (spLock == null) {
                throw new IOException("Unable to get lock on file " + spFile.getPath());
            }
            cis = new CheckedInputStream(fileInputStream, new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            versionNumber = ((CheckedInputStream)cis).getChecksum().getValue();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (spLock != null) {
                    spLock.release();
                }
                if (cis != null) {
                    cis.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("File path " + path + " and checksum is " + versionNumber);
        }
        return versionNumber;
    }

    public static void copyBackUpFile(String propFile) throws Exception {
        Path sourcePath = Paths.get(propFile, new String[0]);
        Path destinationPath = Paths.get(sourcePath + BACKUP_FILE_EXT, new String[0]);
        try {
            if (FilterFileHelper.checkSerialPropFileExists(propFile)) {
                Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem while moving the file " + propFile, e);
        }
    }

    public static void movePropFile(String propFile) throws Exception {
        Path sourcePath = Paths.get(propFile + TMP_FILE_EXT, new String[0]);
        Path destinationPath = Paths.get(propFile, new String[0]);
        try {
            Files.move(sourcePath, destinationPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (FileAlreadyExistsException fae) {
            throw new RuntimeException("Problem while moving the file as the file exists " + propFile, fae);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem while moving the file " + propFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createStringFromProperties(Properties props, String comments) throws IOException {
        String strProp;
        try (StringWriter stringWriter = new StringWriter();){
            props.store(stringWriter, comments);
            strProp = stringWriter.toString();
        }
        return strProp;
    }

    private static Properties createPropertiesFromString(String strProps) throws IOException {
        Properties props = new Properties();
        try (StringReader stringReader = new StringReader(strProps);){
            props.load(stringReader);
        }
        return props;
    }

    public static String createFormattedString(String key, String value) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("\n");
        strBuf.append(key + "=");
        strBuf.append("\\\n\t");
        if (value != null) {
            value = value.replaceAll(";", ";\\\\\n\t");
            strBuf.append(value);
        }
        return strBuf.toString();
    }

    public static String createFormattedString(String value) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("\\\n\t");
        value = value.replaceAll(";", ";\\\\\n\t");
        strBuf.append(value);
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(String propFile, String content) throws Exception {
        FileLock spLock = null;
        FileOutputStream os = null;
        Date date = new Date(System.currentTimeMillis());
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(date);
        strBuf.append(content);
        try {
            FilterFileHelper.copyBackUpFile(propFile);
            File spFile = new File(propFile);
            os = new FileOutputStream(spFile);
            spLock = FileUtils.getFileLock(os.getChannel(), 30000L);
            if (spLock == null) {
                throw new IOException("Unable to get lock on file " + spFile.getPath());
            }
            FileWriter fos = new FileWriter(propFile + TMP_FILE_EXT);
            fos.write(strBuf.toString());
            fos.flush();
            FilterFileHelper.movePropFile(propFile);
        }
        finally {
            block13: {
                try {
                    if (spLock != null) {
                        spLock.release();
                    }
                }
                catch (IOException ignore) {
                    if (!debugLogger.isDebugEnabled()) break block13;
                    debugLogger.debug("Exception during closing lock " + ignore.getMessage());
                }
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("writeProperties path " + propFile + " and content is " + content);
        }
    }
}

