/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.util.HashMap;
import java.util.Map;

public enum JreFilterSupport {
    NONE{

        @Override
        boolean hasFilterSupport() {
            return false;
        }
    }
    ,
    HIDDEN{

        @Override
        String getFilterClassPackage() {
            return JreFilterSupport.HIDDEN_FILTER_PACKAGE;
        }
    }
    ,
    PUBLIC{

        @Override
        String getFilterClassPackage() {
            return JreFilterSupport.PUBLIC_FILTER_PACKAGE;
        }
    };

    private static final String PUBLIC_FILTER_PACKAGE = "java.io";
    private static final String HIDDEN_FILTER_PACKAGE = "sun.misc";
    private static final String RELATIVE_FILTER_CLASS_NAME = ".ObjectInputFilter";
    private static final Map<String, Integer> minimumBuildNums;
    private static final Map<String, Integer> minimumBuildNumsForGlobalFilter;
    private static final Map<String, Integer> minimumBuildNumsForJNDIInjection;

    public static boolean isEnabled() {
        return JreFilterSupport.forJre().hasFilterSupport();
    }

    public static String getLowestSupportedVersion() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.isBlockingJNDIInjectionEnabled()) {
            return version;
        }
        if (version.startsWith("1.6.0_")) {
            version = "1.7.0_201";
        }
        return JreFilterSupport.getJdkLevel(version) + "_" + JreFilterSupport.getMinimumBuildNumForJNDIInjection(version);
    }

    public static String getLowestSupportedVersionForFilter() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.isEnabled()) {
            return version;
        }
        return JreFilterSupport.getJdkLevel(version) + "_" + JreFilterSupport.getMinimumBuildNum(version);
    }

    public static String getLowestSupportedVersionForGlobalFilter() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.isGlobalFilterSupported()) {
            return version;
        }
        if (version.startsWith("1.6.0_")) {
            version = "1.7.0_191";
        }
        return JreFilterSupport.getJdkLevel(version) + "_" + JreFilterSupport.getMinimumBuildNumForGlobalFilter(version);
    }

    public static boolean isGlobalFilterSupported() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.usesJigsawJRENumbering(version)) {
            return true;
        }
        return JreFilterSupport.getBuildNum(version) >= JreFilterSupport.getMinimumBuildNumForGlobalFilter(version);
    }

    public static boolean isBlockingJNDIInjectionEnabled() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.usesJigsawJRENumbering(version)) {
            return true;
        }
        return JreFilterSupport.getBuildNum(version) >= JreFilterSupport.getMinimumBuildNumForJNDIInjection(version);
    }

    public static boolean hasKnownSupportedVersion() {
        return JreFilterSupport.getCurrentVersion().contains("_");
    }

    public static String getCurrentVersion() {
        return System.getProperty("java.version");
    }

    public static String getFilterClass() {
        return JreFilterSupport.forJre().getFilterClassPackage() + RELATIVE_FILTER_CLASS_NAME;
    }

    String getFilterClassPackage() {
        throw new AssertionError((Object)"No filter class package defined for this JDK");
    }

    boolean hasFilterSupport() {
        return true;
    }

    private static JreFilterSupport forJre() {
        String version = JreFilterSupport.getCurrentVersion();
        if (JreFilterSupport.usesJigsawJRENumbering(version)) {
            return PUBLIC;
        }
        if (JreFilterSupport.getBuildNum(version) >= JreFilterSupport.getMinimumBuildNum(version)) {
            return HIDDEN;
        }
        return NONE;
    }

    private static int getMinimumBuildNum(String version) {
        for (Map.Entry<String, Integer> entry : minimumBuildNums.entrySet()) {
            if (!version.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return Integer.MAX_VALUE;
    }

    private static int getMinimumBuildNumForGlobalFilter(String version) {
        for (Map.Entry<String, Integer> entry : minimumBuildNumsForGlobalFilter.entrySet()) {
            if (!version.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return Integer.MAX_VALUE;
    }

    private static int getMinimumBuildNumForJNDIInjection(String version) {
        for (Map.Entry<String, Integer> entry : minimumBuildNumsForJNDIInjection.entrySet()) {
            if (!version.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return Integer.MAX_VALUE;
    }

    private static boolean usesJigsawJRENumbering(String version) {
        return !version.startsWith("1.");
    }

    private static String getJdkLevel(String version) {
        return version.substring(0, version.indexOf("_"));
    }

    private static int getBuildNum(String version) {
        String substring = version.substring(version.indexOf("_") + 1);
        try {
            return Integer.parseInt(substring);
        }
        catch (NumberFormatException e) {
            for (int i = 0; i < substring.length(); ++i) {
                if (Character.isDigit(substring.charAt(i))) continue;
                return Integer.parseInt(substring.substring(0, i));
            }
            throw e;
        }
    }

    static {
        minimumBuildNums = new HashMap<String, Integer>();
        minimumBuildNums.put("1.6.", 141);
        minimumBuildNums.put("1.7.", 131);
        minimumBuildNums.put("1.8.", 121);
        minimumBuildNumsForGlobalFilter = new HashMap<String, Integer>();
        minimumBuildNumsForGlobalFilter.put("1.7.", 191);
        minimumBuildNumsForGlobalFilter.put("1.8.", 181);
        minimumBuildNumsForJNDIInjection = new HashMap<String, Integer>();
        minimumBuildNumsForJNDIInjection.put("1.7.", 201);
        minimumBuildNumsForJNDIInjection.put("1.8.", 191);
    }
}

