/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.io.oif.FilterConfigurationException;
import weblogic.utils.io.oif.FilterFileHelper;
import weblogic.utils.io.oif.JreFilterSupport;

final class WebLogicFilterConfig {
    private static String propFileDir;
    private static String propFileLocation;
    private static final String SERIAL_FILTER_PROPERTY_FILENAME = "jep290-recorded.serial.properties";
    private static final String SERIAL_HEAD_FILTER_PROPERTY = "weblogic.oif.head.serialFilter";
    private static final String SERIAL_HEAD_GLOBAL_FILTER_PROPERTY = "weblogic.oif.head.serialGlobalFilter";
    private static final String SERIAL_FILTER_PROPERTY = "weblogic.oif.serialFilter";
    private static final String SERIAL_GLOBAL_FILTER_PROPERTY = "weblogic.oif.serialGlobalFilter";
    private static final String SERIAL_UNAUTHENTICATED_FILTER_PROPERTY = "weblogic.oif.serialUnauthenticatedFilter";
    private static final String SERIAL_FILTER_MODE_PROPERTY = "weblogic.oif.serialFilterMode";
    private static final String SERIAL_FILTER_MODE_COMBINE = "combine";
    private static final String SERIAL_FILTER_MODE_REPLACE = "replace";
    private static final String SERIAL_FILTER_MODE_DISABLE = "disable";
    private static final String SERIAL_FILTER_SCOPE_PROPERTY = "weblogic.oif.serialFilterScope";
    private static final String SERIAL_FILTER_SCOPE_GLOBAL = "global";
    private static final String SERIAL_FILTER_SCOPE_WEBLOGIC = "weblogic";
    private static final String SERIAL_FILTER_VIOLATIONACTION_LOG = "log";
    private static final String SERIAL_FILTER_VIOLATIONACTION_DENY = "deny";
    private static final String SERIAL_FILTER_VIOLATIONACTION_IGNORE = "ignore";
    private static final String SERIAL_FILTER_LOGGING_PROPERTY = "weblogic.oif.serialFilterLogging";
    private static final String SERIAL_PROP_DIRS = "weblogic.oif.serialPropDirectories";
    private static final String SERIAL_PROP_POLLING_FILE_INTERVAL = "weblogic.oif.serialPropPollingFileInterval";
    private static final String SERIAL_PROP_RECORDING_SENDER_INTERVAL = "weblogic.oif.serialRecordingSenderInterval";
    private static final String SERIAL_PROP_RECORDING_MAX_ARRAY_SIZE = "weblogic.oif.serialRecordingArraySize";
    private static final String BLACKLIST_PROPERTY = "weblogic.rmi.blacklist";
    private static final String DISABLE_BLACKLIST_PROPERTY = "weblogic.rmi.disableblacklist";
    private static final String DISABLE_DEFAULT_BLACKLIST_PROPERTY = "weblogic.rmi.disabledefaultblacklist";
    private static DebugLogger debugLogger;
    private static final String[] DEFAULT_LIMITS;
    private static final String[] DEFAULT_ALLOWLIST_PACKAGES;
    private static final String[] DEFAULT_BLACKLIST_PACKAGES;
    private static final String[] DEFAULT_ALLOWLIST_CLASSES;
    private static final String[] DEFAULT_BLACKLIST_CLASSES;
    private static final String[] DEFAULT_WLS_ONLY_ALLOWLIST_PACKAGES;
    private static final String[] DEFAULT_WLS_ONLY_BLACKLIST_PACKAGES;
    private static final String[] DEFAULT_WLS_ONLY_ALLOWLIST_CLASSES;
    private static final String[] DEFAULT_WLS_ONLY_BLACKLIST_CLASSES;
    private static final String[] DEFAULT_UNAUTHENTICATED_USER_ALLOWLISTS;
    private boolean isJreFilteringAvailable = false;
    private boolean isJreGlobalFilterConfigured = false;
    private String allowSerialFilter = null;
    private String allowSerialGlobalFilter = null;
    private String blockSerialFilter = null;
    private String blockSerialGlobalFilter = null;
    private String unauthenticatedSerialFilter = null;
    private String propUnauthenticatedSerialFilter = null;
    private FilterMode filterMode = null;
    private FilterScope filterScope = null;
    private boolean filterLoggingEnabled = false;
    private String serialPropDirs = null;
    private long serialPropFileInterval = 60000L;
    private boolean allowListRecordingEnabled = false;
    private FilterViolationAction filterViolationAction = FilterViolationAction.IGNORE;
    private FilterViolationAction previousFilterViolationAction = FilterViolationAction.IGNORE;
    private int serialRecordingSenderInterval = 10000;
    private int serialRecordingMaxArraySize = 10;
    private Set<String> BLACKLIST = null;
    private static String DOMAIN_DIR_PATH;
    private static String SHIPHOME_DIR_PATH;
    private static Map<String, String> headSerialFilterPropFilesContent;
    private static Map<String, String> headGlobalSerialFilterPropFilesContent;
    private static Map<String, String> serialFilterPropFilesContent;
    private static Map<String, String> globalSerialFilterPropFilesContent;
    private static Map<String, String> unauthenticatedSerialFilterPropFilesContent;

    private WebLogicFilterConfig() {
    }

    WebLogicFilterConfig(boolean isJreFilteringAvailable, boolean isJreGlobalFilterConfigured, String propFileDir) throws Exception {
        WebLogicFilterConfig.propFileDir = propFileDir != null ? propFileDir : System.getProperty("java.io.tmpdir");
        propFileLocation = propFileDir + File.separator + SERIAL_FILTER_PROPERTY_FILENAME;
        this.isJreFilteringAvailable = isJreFilteringAvailable;
        this.isJreGlobalFilterConfigured = isJreGlobalFilterConfigured;
        if (!this.processWebLogicSerialFilterProperties() && !this.processLegacyBlacklistProperties()) {
            this.processDefaultConfiguration();
        }
        try {
            String serialPropRecordingSenderIntervalStr;
            String serialPropFileIntervalStr;
            String serialPropDirs = System.getProperty(SERIAL_PROP_DIRS);
            if (serialPropDirs != null) {
                this.serialPropDirs = serialPropDirs;
            }
            if ((serialPropFileIntervalStr = System.getProperty(SERIAL_PROP_POLLING_FILE_INTERVAL, "60000")) != null) {
                this.serialPropFileInterval = Long.parseLong(serialPropFileIntervalStr);
            }
            if ((serialPropRecordingSenderIntervalStr = System.getProperty(SERIAL_PROP_RECORDING_SENDER_INTERVAL, "10000")) != null) {
                this.serialRecordingSenderInterval = Integer.parseInt(serialPropRecordingSenderIntervalStr);
            }
            this.serialRecordingMaxArraySize = Integer.parseInt(System.getProperty(SERIAL_PROP_RECORDING_MAX_ARRAY_SIZE, "10"));
            this.filterLoggingEnabled = Boolean.getBoolean(SERIAL_FILTER_LOGGING_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    WebLogicFilterConfig(boolean isJreFilteringAvailable, boolean isJreGlobalFilterConfigured) throws Exception {
        this(isJreFilteringAvailable, isJreGlobalFilterConfigured, null);
    }

    public String getPropFileLocation() {
        return propFileLocation;
    }

    public String getPropFileName() {
        return SERIAL_FILTER_PROPERTY_FILENAME;
    }

    public String getSerialFilterProperty() {
        return SERIAL_FILTER_PROPERTY;
    }

    public String getSerialGlobalFilterProperty() {
        return SERIAL_GLOBAL_FILTER_PROPERTY;
    }

    public String getSerialUnauthenticatedFilterProperty() {
        return SERIAL_UNAUTHENTICATED_FILTER_PROPERTY;
    }

    public String getWebLogicSerialFilter() {
        if (this.isWebLogicAllowListEnabled()) {
            return this.allowSerialFilter;
        }
        return this.blockSerialFilter;
    }

    public String getWebLogicAllowSerialFilter() {
        return this.allowSerialFilter;
    }

    public String getWebLogicBlockSerialFilter() {
        return this.blockSerialFilter;
    }

    public String getWebLogicSerialGlobalFilter() {
        if (this.isWebLogicAllowListEnabled()) {
            return this.allowSerialGlobalFilter;
        }
        return this.blockSerialGlobalFilter;
    }

    public String getWebLogicAllowSerialGlobalFilter() {
        return this.allowSerialGlobalFilter;
    }

    public String getWebLogicBlockSerialGlobalFilter() {
        return this.blockSerialGlobalFilter;
    }

    public String getUnauthenticatedSerialFilter() {
        return this.unauthenticatedSerialFilter;
    }

    public String getPropUnauthenticatedSerialFilter() {
        return this.propUnauthenticatedSerialFilter;
    }

    public FilterMode getWebLogicSerialFilterMode() {
        return this.filterMode;
    }

    public FilterScope getWebLogicSerialFilterScope() {
        return this.filterScope;
    }

    long getWebLogicSerialFilterPollingInterval() {
        return this.serialPropFileInterval;
    }

    int getWebLogicSerialRecordingMaxArraySize() {
        return this.serialRecordingMaxArraySize;
    }

    int getWebLogicSerialRecordingSenderInterval() {
        return this.serialRecordingSenderInterval;
    }

    String getWebLogicSerialFilterPropDirs() {
        return this.serialPropDirs;
    }

    Set<String> getLegacyBlacklist() {
        return this.BLACKLIST;
    }

    public boolean isWebLogicSerialFilterLogEnabled() {
        return this.filterLoggingEnabled;
    }

    boolean isWebLogicAllowListRecordingEnabled() {
        return this.allowListRecordingEnabled;
    }

    void setWebLogicAllowListRecordingEnabled(boolean allow) {
        this.allowListRecordingEnabled = allow;
    }

    boolean isWebLogicAllowListEnabled() {
        return this.filterViolationAction == FilterViolationAction.LOG || this.filterViolationAction == FilterViolationAction.DENY;
    }

    public String getWebLogicAllowListViolationAction() {
        return this.filterViolationAction.toString();
    }

    public boolean isWebLogicAllowListLogViolationAction() {
        try {
            if (this.filterViolationAction == FilterViolationAction.LOG) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isWebLogicAllowListViolationActionChanged() {
        try {
            if (this.filterViolationAction != this.previousFilterViolationAction) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void setWebLogicAllowListViolationAction(String violation) throws Exception {
        FilterViolationAction violationAction = WebLogicFilterConfig.getFilterViolationAction(violation);
        if (violationAction != this.filterViolationAction) {
            this.previousFilterViolationAction = this.filterViolationAction;
        }
        this.filterViolationAction = violationAction;
    }

    public ArrayList<String> getWebLogicSerialFilterElements(ElementType type, FilterScope scope) {
        return this.getWebLogicSerialFilterElements(null, type, scope);
    }

    public ArrayList<String> getWebLogicSerialFilterElements(String filter, ElementType type) {
        return this.getWebLogicSerialFilterElements(filter, type, null);
    }

    public ArrayList<String> getWebLogicSerialFilterElements(String inputFilter, ElementType type, FilterScope scope) {
        String filter;
        String string = inputFilter != null ? inputFilter : (filter = scope == FilterScope.WEBLOGIC ? this.allowSerialFilter : this.allowSerialGlobalFilter);
        if (filter == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> limits = new ArrayList<String>();
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> blocklists = new ArrayList<String>();
        ArrayList<String> allowlists = new ArrayList<String>();
        String[] elements = filter.split(";");
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (element.contains("=")) {
                limits.add(element);
                continue;
            }
            if (element.startsWith("!") && element.endsWith(".*")) {
                packages.add(element.substring(1, element.length() - 2));
                if (blocklists.contains(element.substring(1))) continue;
                blocklists.add(element.substring(1));
                continue;
            }
            if (element.startsWith("!")) {
                classes.add(element.substring(1));
                if (blocklists.contains(element.substring(1))) continue;
                blocklists.add(element.substring(1));
                continue;
            }
            if (allowlists.contains(element)) continue;
            allowlists.add(element);
        }
        if (type.equals((Object)ElementType.LIMIT)) {
            return limits;
        }
        if (type.equals((Object)ElementType.PACKAGE)) {
            return packages;
        }
        if (type.equals((Object)ElementType.CLASS)) {
            return classes;
        }
        if (type.equals((Object)ElementType.BLOCKLIST)) {
            return blocklists;
        }
        if (type.equals((Object)ElementType.ALLOWLIST)) {
            return allowlists;
        }
        return new ArrayList<String>();
    }

    private boolean processWebLogicSerialFilterProperties() throws Exception {
        if (!WebLogicFilterConfig.isSerialFilterConfigured(null)) {
            return false;
        }
        if (!this.isJreFilteringAvailable) {
            throw new FilterConfigurationException("JRE serial filtering configured but not available");
        }
        boolean processed = this.processWebLogicSerialFilterProperties(null);
        return processed;
    }

    boolean processWebLogicSerialFilterProperties(String file) throws Exception {
        FilterScope scope;
        FilterMode mode;
        String fileLocation = null;
        if (file != null) {
            fileLocation = file;
        }
        if (fileLocation != null && !FilterFileHelper.checkSerialPropFileExists(fileLocation)) {
            this.processDeletedFile(fileLocation);
        }
        if (fileLocation != null && !WebLogicFilterConfig.isSerialFilterConfigured(fileLocation)) {
            return false;
        }
        String headFilter = null;
        String headGlobalFilter = null;
        String filter = null;
        String globalFilter = null;
        String unauthenticatedFilter = null;
        if (fileLocation != null && FilterFileHelper.checkSerialPropFileExists(fileLocation)) {
            Properties props = FilterFileHelper.loadProperties(fileLocation);
            this.processAddedFile(fileLocation, props);
            String filterModeStr = System.getProperty(SERIAL_FILTER_MODE_PROPERTY) != null ? System.getProperty(SERIAL_FILTER_MODE_PROPERTY) : props.getProperty(SERIAL_FILTER_MODE_PROPERTY, SERIAL_FILTER_MODE_COMBINE);
            mode = WebLogicFilterConfig.getFilterMode(filterModeStr);
            String filterScopeStr = System.getProperty(SERIAL_FILTER_SCOPE_PROPERTY) != null ? System.getProperty(SERIAL_FILTER_SCOPE_PROPERTY) : props.getProperty(SERIAL_FILTER_SCOPE_PROPERTY, SERIAL_FILTER_SCOPE_GLOBAL);
            scope = WebLogicFilterConfig.getFilterScope(filterScopeStr);
            this.filterLoggingEnabled = Boolean.parseBoolean(System.getProperty(SERIAL_FILTER_LOGGING_PROPERTY) != null ? System.getProperty(SERIAL_FILTER_LOGGING_PROPERTY) : props.getProperty(SERIAL_FILTER_LOGGING_PROPERTY));
        } else {
            String filterModeStr = System.getProperty(SERIAL_FILTER_MODE_PROPERTY, SERIAL_FILTER_MODE_COMBINE);
            mode = WebLogicFilterConfig.getFilterMode(filterModeStr);
            String filterScopeStr = System.getProperty(SERIAL_FILTER_SCOPE_PROPERTY, SERIAL_FILTER_SCOPE_GLOBAL);
            scope = WebLogicFilterConfig.getFilterScope(filterScopeStr);
        }
        if (System.getProperty(SERIAL_HEAD_FILTER_PROPERTY) != null) {
            headFilter = System.getProperty(SERIAL_HEAD_FILTER_PROPERTY);
        }
        if (System.getProperty(SERIAL_HEAD_GLOBAL_FILTER_PROPERTY) != null) {
            headGlobalFilter = System.getProperty(SERIAL_HEAD_GLOBAL_FILTER_PROPERTY);
        }
        if (System.getProperty(SERIAL_FILTER_PROPERTY) != null) {
            filter = System.getProperty(SERIAL_FILTER_PROPERTY);
        }
        if (System.getProperty(SERIAL_GLOBAL_FILTER_PROPERTY) != null) {
            globalFilter = System.getProperty(SERIAL_GLOBAL_FILTER_PROPERTY);
        }
        if (System.getProperty(SERIAL_UNAUTHENTICATED_FILTER_PROPERTY) != null) {
            unauthenticatedFilter = System.getProperty(SERIAL_UNAUTHENTICATED_FILTER_PROPERTY);
        }
        if (this.isJreGlobalFilterConfigured && scope == FilterScope.GLOBAL) {
            throw new FilterConfigurationException("JRE process-wide serial filter already configured");
        }
        this.constructSerialFilter(headFilter, headGlobalFilter, filter, globalFilter, unauthenticatedFilter, mode, scope, null);
        this.propUnauthenticatedSerialFilter = unauthenticatedFilter;
        if (this.filterLoggingEnabled || debugLogger.isDebugEnabled()) {
            debugLogger.debug("allowSerialFilter: " + this.allowSerialFilter);
            debugLogger.debug("allowSerialGlobalFilter: " + this.allowSerialGlobalFilter);
            debugLogger.debug("unauthenticatedSerialFilter: " + this.unauthenticatedSerialFilter);
            debugLogger.debug("blockSerialFilter: " + this.blockSerialFilter);
            debugLogger.debug("blockSerialGlobalFilter: " + this.blockSerialGlobalFilter);
        }
        return true;
    }

    private void processDeletedFile(String fileLocation) {
        if (headSerialFilterPropFilesContent.containsKey(fileLocation)) {
            headSerialFilterPropFilesContent.remove(fileLocation);
        }
        if (headGlobalSerialFilterPropFilesContent.containsKey(fileLocation)) {
            headGlobalSerialFilterPropFilesContent.remove(fileLocation);
        }
        if (serialFilterPropFilesContent.containsKey(fileLocation)) {
            serialFilterPropFilesContent.remove(fileLocation);
        }
        if (globalSerialFilterPropFilesContent.containsKey(fileLocation)) {
            globalSerialFilterPropFilesContent.remove(fileLocation);
        }
        if (unauthenticatedSerialFilterPropFilesContent.containsKey(fileLocation)) {
            unauthenticatedSerialFilterPropFilesContent.remove(fileLocation);
        }
    }

    private void processAddedFile(String fileLocation, Properties props) {
        String propHeadFilter = props.getProperty(SERIAL_HEAD_FILTER_PROPERTY);
        String propHeadGlobalFilter = props.getProperty(SERIAL_HEAD_GLOBAL_FILTER_PROPERTY);
        String propFilter = props.getProperty(SERIAL_FILTER_PROPERTY);
        String propGlobalFilter = props.getProperty(SERIAL_GLOBAL_FILTER_PROPERTY);
        String propUnauthenticatedFiler = props.getProperty(SERIAL_UNAUTHENTICATED_FILTER_PROPERTY);
        if (propHeadFilter != null && !propHeadFilter.isEmpty()) {
            headSerialFilterPropFilesContent.put(fileLocation, propHeadFilter);
        }
        if (propHeadGlobalFilter != null && !propHeadGlobalFilter.isEmpty()) {
            headGlobalSerialFilterPropFilesContent.put(fileLocation, propHeadGlobalFilter);
        }
        if (propFilter != null && !propFilter.isEmpty()) {
            serialFilterPropFilesContent.put(fileLocation, propFilter);
        }
        if (propGlobalFilter != null && !propGlobalFilter.isEmpty()) {
            globalSerialFilterPropFilesContent.put(fileLocation, propGlobalFilter);
        }
        if (propUnauthenticatedFiler != null && !propUnauthenticatedFiler.isEmpty()) {
            unauthenticatedSerialFilterPropFilesContent.put(fileLocation, propUnauthenticatedFiler);
        }
    }

    private boolean processLegacyBlacklistProperties() {
        boolean isBlacklistDisabled = Boolean.getBoolean(DISABLE_BLACKLIST_PROPERTY);
        boolean isDefaultBlacklistDisabled = Boolean.getBoolean(DISABLE_DEFAULT_BLACKLIST_PROPERTY);
        String blacklist = System.getProperty(BLACKLIST_PROPERTY);
        if (blacklist == null && !isBlacklistDisabled && !isDefaultBlacklistDisabled) {
            return false;
        }
        if (this.isJreFilteringAvailable) {
            if (isBlacklistDisabled) {
                this.constructSerialFilter(null, null, null, null, null, FilterMode.DISABLE, FilterScope.WEBLOGIC, null);
            } else {
                StringBuilder allowBuilder = new StringBuilder();
                HashSet<String> deletions = new HashSet<String>(32);
                FilterMode mode = isDefaultBlacklistDisabled ? FilterMode.REPLACE : FilterMode.COMBINE;
                WebLogicFilterConfig.convertLegacyBlacklistToSerialFilter(blacklist, allowBuilder, deletions);
                this.constructSerialFilter(null, null, allowBuilder.toString(), null, null, mode, WebLogicFilterConfig.getDefaultFilterScope(), deletions);
            }
        } else {
            this.constructLegacyBlacklist(blacklist, isBlacklistDisabled, isDefaultBlacklistDisabled);
        }
        return true;
    }

    private void processDefaultConfiguration() {
        if (this.isJreFilteringAvailable) {
            this.constructSerialFilter(null, null, null, null, null, FilterMode.COMBINE, WebLogicFilterConfig.getDefaultFilterScope(), null);
        } else {
            this.constructLegacyBlacklist(null, false, false);
        }
    }

    private void constructSerialFilter(String headFilter, String headGlobalFilter, String filter, String globalFilter, String unauthenticatedFilter, FilterMode mode, FilterScope scope, Set<String> excludeFromDefaults) {
        String gFilter;
        String filterString = filter;
        if (filterString == null) {
            filterString = "";
        }
        String globalFilterString = globalFilter == null ? filterString : globalFilter;
        String unauthenticatedFilterString = unauthenticatedFilter == null ? "" : unauthenticatedFilter;
        StringBuilder headBuilder = new StringBuilder();
        StringBuilder headGlobalBuilder = new StringBuilder();
        StringBuilder allowBuilder = new StringBuilder();
        StringBuilder blockBuilder = new StringBuilder();
        StringBuilder blockGlobalBuilder = new StringBuilder();
        StringBuilder allowGlobalBuilder = new StringBuilder();
        StringBuilder unauthenticatedBuilder = new StringBuilder();
        if (mode == FilterMode.DISABLE) {
            this.allowSerialFilter = "";
            this.allowSerialGlobalFilter = "";
            this.unauthenticatedSerialFilter = "";
            this.blockSerialFilter = "";
            this.blockSerialGlobalFilter = "";
        } else if (mode == FilterMode.REPLACE) {
            if (filterString != null && !filterString.isEmpty()) {
                allowBuilder.append(filterString + ";");
                blockBuilder.append(filterString + ";");
            }
            if (globalFilterString != null && !globalFilterString.isEmpty()) {
                allowGlobalBuilder.append(globalFilterString + ";");
                blockGlobalBuilder.append(globalFilterString + ";");
            }
            if (unauthenticatedFilterString != null && !unauthenticatedFilterString.isEmpty()) {
                unauthenticatedBuilder.append(unauthenticatedFilterString + ";");
            }
            String string = this.constructFileFilter(serialFilterPropFilesContent);
            allowBuilder.append(string);
            blockBuilder.append(string);
            gFilter = this.constructFileFilter(globalSerialFilterPropFilesContent);
            allowGlobalBuilder.append(gFilter);
            blockGlobalBuilder.append(gFilter);
            String uFilter = this.constructFileFilter(unauthenticatedSerialFilterPropFilesContent);
            unauthenticatedBuilder.append(uFilter);
        } else {
            for (String s : DEFAULT_LIMITS) {
                headBuilder.append(s + ";");
            }
            if (filterString != null && !filterString.isEmpty()) {
                allowBuilder.append(filterString + ";");
                blockBuilder.append(filterString + ";");
            }
            if (globalFilterString != null && !globalFilterString.isEmpty()) {
                allowGlobalBuilder.append(globalFilterString + ";");
                blockGlobalBuilder.append(globalFilterString + ";");
            }
            if (unauthenticatedFilterString != null && !unauthenticatedFilterString.isEmpty()) {
                unauthenticatedBuilder.append(unauthenticatedFilterString + ";");
            }
            String string = this.constructFileFilter(serialFilterPropFilesContent);
            allowBuilder.append(string);
            blockBuilder.append(string);
            gFilter = this.constructFileFilter(globalSerialFilterPropFilesContent);
            allowGlobalBuilder.append(gFilter);
            blockGlobalBuilder.append(gFilter);
            String uFilter = this.constructFileFilter(unauthenticatedSerialFilterPropFilesContent);
            unauthenticatedBuilder.append(uFilter);
            for (String s : DEFAULT_WLS_ONLY_BLACKLIST_CLASSES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append("!" + s + ";");
                blockBuilder.append("!" + s + ";");
            }
            for (String s : DEFAULT_WLS_ONLY_BLACKLIST_PACKAGES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append("!" + s + ".*;");
                blockBuilder.append("!" + s + ".*;");
            }
            for (String s : DEFAULT_BLACKLIST_CLASSES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append("!" + s + ";");
                allowGlobalBuilder.append("!" + s + ";");
                blockBuilder.append("!" + s + ";");
                blockGlobalBuilder.append("!" + s + ";");
            }
            for (String s : DEFAULT_BLACKLIST_PACKAGES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append("!" + s + ".*;");
                allowGlobalBuilder.append("!" + s + ".*;");
                blockBuilder.append("!" + s + ".*;");
                blockGlobalBuilder.append("!" + s + ".*;");
            }
            for (String s : DEFAULT_UNAUTHENTICATED_USER_ALLOWLISTS) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                unauthenticatedBuilder.append(s + ";");
            }
            for (String s : DEFAULT_WLS_ONLY_ALLOWLIST_CLASSES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append(s + ";");
                allowGlobalBuilder.append(s + ";");
            }
            for (String s : DEFAULT_WLS_ONLY_ALLOWLIST_PACKAGES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append(s + ";");
                allowGlobalBuilder.append(s + ";");
            }
            for (String s : DEFAULT_ALLOWLIST_CLASSES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append(s + ";");
                allowGlobalBuilder.append(s + ";");
            }
            for (String s : DEFAULT_ALLOWLIST_PACKAGES) {
                if (excludeFromDefaults != null && excludeFromDefaults.contains(s)) continue;
                allowBuilder.append(s + ";");
                allowGlobalBuilder.append(s + ";");
            }
        }
        if (allowBuilder.length() > 0 && allowBuilder.charAt(allowBuilder.length() - 1) == ';') {
            allowBuilder.deleteCharAt(allowBuilder.length() - 1);
        }
        if (allowGlobalBuilder.length() > 0 && allowGlobalBuilder.charAt(allowGlobalBuilder.length() - 1) == ';') {
            allowGlobalBuilder.deleteCharAt(allowGlobalBuilder.length() - 1);
        }
        if (blockBuilder.length() > 0 && blockBuilder.charAt(blockBuilder.length() - 1) == ';') {
            blockBuilder.deleteCharAt(blockBuilder.length() - 1);
        }
        if (blockGlobalBuilder.length() > 0 && blockGlobalBuilder.charAt(blockGlobalBuilder.length() - 1) == ';') {
            blockGlobalBuilder.deleteCharAt(blockGlobalBuilder.length() - 1);
        }
        if (unauthenticatedBuilder.length() > 0 && unauthenticatedBuilder.charAt(unauthenticatedBuilder.length() - 1) == ';') {
            unauthenticatedBuilder.deleteCharAt(unauthenticatedBuilder.length() - 1);
        }
        if (mode != FilterMode.DISABLE) {
            if (headFilter != null && !headFilter.isEmpty()) {
                headBuilder.append(headFilter).append(";");
            }
            String string = this.constructFileFilter(headSerialFilterPropFilesContent);
            headBuilder.append(string);
            if (headGlobalFilter != null && !headGlobalFilter.isEmpty()) {
                headGlobalBuilder.append(headGlobalFilter).append(";");
            }
            String headSerialGlobalFilter = this.constructFileFilter(headGlobalSerialFilterPropFilesContent);
            headGlobalBuilder.append(headSerialGlobalFilter);
            this.allowSerialFilter = headBuilder.length() > 0 || allowBuilder.length() > 0 ? headBuilder.toString() + this.reOrderFilter(allowBuilder.toString(), true) : "!*";
            this.allowSerialGlobalFilter = headGlobalBuilder.length() > 0 || allowGlobalBuilder.length() > 0 ? headGlobalBuilder.toString() + this.reOrderFilter(allowGlobalBuilder.toString(), true) : "!*";
            this.blockSerialFilter = headBuilder.length() > 0 || blockBuilder.length() > 0 ? headBuilder.toString() + blockBuilder.toString() : "";
            this.blockSerialGlobalFilter = headGlobalBuilder.length() > 0 || blockGlobalBuilder.length() > 0 ? headGlobalBuilder.toString() + blockGlobalBuilder.toString() : "";
            this.unauthenticatedSerialFilter = unauthenticatedBuilder.length() > 0 ? unauthenticatedBuilder.append(";!*").toString() : "!*";
        }
        this.filterMode = mode;
        this.filterScope = scope;
    }

    private String reOrderFilter(String filter, boolean reject) {
        ArrayList<String> limits = this.getWebLogicSerialFilterElements(filter, ElementType.LIMIT);
        ArrayList<String> allBlockLists = this.getWebLogicSerialFilterElements(filter, ElementType.BLOCKLIST);
        ArrayList<String> allAllowLists = this.getWebLogicSerialFilterElements(filter, ElementType.ALLOWLIST);
        StringBuilder filterBuilder = new StringBuilder();
        if (!limits.isEmpty()) {
            filterBuilder.append(limits.get(limits.size() - 1) + ";");
        }
        for (String s : allBlockLists) {
            filterBuilder.append("!" + s + ";");
        }
        for (String s : allAllowLists) {
            filterBuilder.append(s + ";");
        }
        if (filterBuilder.length() > 0 && filterBuilder.charAt(filterBuilder.length() - 1) == ';') {
            filterBuilder.deleteCharAt(filterBuilder.length() - 1);
        }
        if (reject) {
            filterBuilder.append(";!*");
        }
        return filterBuilder.toString();
    }

    private String constructFileFilter(Map<String, String> filesContent) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder securityFilesBuilder = new StringBuilder();
        StringBuilder shiphomeFilesBuilder = new StringBuilder();
        for (Map.Entry<String, String> me : filesContent.entrySet()) {
            String fileKey = me.getKey();
            String fileValue = me.getValue();
            if (fileValue != null && !fileValue.isEmpty() && fileKey.contains(DOMAIN_DIR_PATH)) {
                securityFilesBuilder.append(fileValue + ";");
                continue;
            }
            if (fileValue != null && !fileValue.isEmpty() && fileKey.contains(SHIPHOME_DIR_PATH)) {
                shiphomeFilesBuilder.append(fileValue + ";");
                continue;
            }
            buffer.append(fileValue + ";");
        }
        buffer.append(securityFilesBuilder.toString());
        buffer.append(shiphomeFilesBuilder.toString());
        return buffer.toString();
    }

    private void constructLegacyBlacklist(String blacklist, boolean isBlacklistDisabled, boolean isDefaultBlacklistDisabled) {
        HashSet<String> blacklistSet = null;
        if (!isBlacklistDisabled) {
            blacklistSet = new HashSet<String>(32);
            if (!isDefaultBlacklistDisabled) {
                for (String s : DEFAULT_WLS_ONLY_BLACKLIST_CLASSES) {
                    blacklistSet.add(s);
                }
                for (String s : DEFAULT_WLS_ONLY_BLACKLIST_PACKAGES) {
                    blacklistSet.add(s);
                }
                for (String s : DEFAULT_BLACKLIST_CLASSES) {
                    blacklistSet.add(s);
                }
                for (String s : DEFAULT_BLACKLIST_PACKAGES) {
                    blacklistSet.add(s);
                }
            }
            if (blacklist != null) {
                StringTokenizer st = new StringTokenizer(blacklist, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.startsWith("+")) {
                        blacklistSet.add(token.substring(1));
                        continue;
                    }
                    if (token.startsWith("-")) {
                        blacklistSet.remove(token.substring(1));
                        continue;
                    }
                    blacklistSet.add(token);
                }
            }
            if (blacklistSet.isEmpty()) {
                blacklistSet = null;
            }
        }
        this.BLACKLIST = blacklistSet;
    }

    private static void convertLegacyBlacklistToSerialFilter(String inBlacklist, StringBuilder outFilter, Set<String> outDeletions) {
        if (inBlacklist == null) {
            return;
        }
        if (outFilter == null || outDeletions == null) {
            throw new IllegalArgumentException("Unexpected null parameter");
        }
        StringTokenizer st = new StringTokenizer(inBlacklist, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("+")) {
                outFilter.append("!" + WebLogicFilterConfig.getFilterExpressionForName(token.substring(1)) + ";");
                continue;
            }
            if (token.startsWith("-")) {
                outDeletions.add(token.substring(1));
                continue;
            }
            outFilter.append("!" + WebLogicFilterConfig.getFilterExpressionForName(token) + ";");
        }
        if (outFilter.length() > 0 && outFilter.charAt(outFilter.length() - 1) == ';') {
            outFilter.deleteCharAt(outFilter.length() - 1);
        }
    }

    private static boolean isSerialFilterConfigured(String fileLocation) throws Exception {
        try {
            if (fileLocation != null && FilterFileHelper.checkSerialPropFileExists(fileLocation)) {
                Properties props = FilterFileHelper.loadProperties(fileLocation);
                if (props == null) {
                    return false;
                }
                return props.getProperty(SERIAL_FILTER_PROPERTY) != null || props.getProperty(SERIAL_GLOBAL_FILTER_PROPERTY) != null || props.getProperty(SERIAL_FILTER_MODE_PROPERTY) != null || props.getProperty(SERIAL_FILTER_SCOPE_PROPERTY) != null || props.getProperty(SERIAL_UNAUTHENTICATED_FILTER_PROPERTY) != null;
            }
            return System.getProperty(SERIAL_FILTER_PROPERTY) != null || System.getProperty(SERIAL_GLOBAL_FILTER_PROPERTY) != null || System.getProperty(SERIAL_FILTER_MODE_PROPERTY) != null || System.getProperty(SERIAL_FILTER_SCOPE_PROPERTY) != null || System.getProperty(SERIAL_UNAUTHENTICATED_FILTER_PROPERTY) != null;
        }
        catch (SecurityException appletIgnore) {
            return false;
        }
    }

    private static FilterMode getFilterMode(String propValue) {
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_MODE_COMBINE)) {
            return FilterMode.COMBINE;
        }
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_MODE_REPLACE)) {
            return FilterMode.REPLACE;
        }
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_MODE_DISABLE)) {
            return FilterMode.DISABLE;
        }
        throw new FilterConfigurationException("Invalid setting: '" + propValue + "'");
    }

    private static FilterScope getFilterScope(String propValue) {
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_SCOPE_GLOBAL)) {
            return FilterScope.GLOBAL;
        }
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_SCOPE_WEBLOGIC)) {
            return FilterScope.WEBLOGIC;
        }
        throw new FilterConfigurationException("Invalid setting: '" + propValue + "'");
    }

    private static FilterViolationAction getFilterViolationAction(String propValue) {
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_VIOLATIONACTION_LOG)) {
            return FilterViolationAction.LOG;
        }
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_VIOLATIONACTION_DENY)) {
            return FilterViolationAction.DENY;
        }
        if (propValue.equalsIgnoreCase(SERIAL_FILTER_VIOLATIONACTION_IGNORE)) {
            return FilterViolationAction.IGNORE;
        }
        throw new FilterConfigurationException("Invalid setting: '" + propValue + "'");
    }

    private static String getFilterExpressionForName(String name) {
        if (name != null && !name.isEmpty() && name.toLowerCase().equals(name)) {
            return new String(name + ".*");
        }
        return name;
    }

    private static FilterScope getDefaultFilterScope() {
        if (JreFilterSupport.isGlobalFilterSupported()) {
            return FilterScope.GLOBAL;
        }
        return FilterScope.WEBLOGIC;
    }

    static {
        debugLogger = DebugLogger.getDebugLogger("DebugAllowList");
        DEFAULT_LIMITS = new String[]{"maxdepth=100"};
        DEFAULT_ALLOWLIST_PACKAGES = new String[0];
        DEFAULT_BLACKLIST_PACKAGES = new String[]{"org.apache.commons.collections.functors", "com.sun.org.apache.xalan.internal.xsltc.trax", "javassist", "java.rmi.activation", "sun.rmi.server", "org.jboss.interceptor.builder", "org.jboss.interceptor.reader", "org.jboss.interceptor.proxy", "org.jboss.interceptor.spi.metadata", "org.jboss.interceptor.spi.model", "com.bea.core.repackaged.springframework.aop.aspectj", "com.bea.core.repackaged.springframework.aop.aspectj.annotation", "com.bea.core.repackaged.springframework.aop.aspectj.autoproxy", "com.bea.core.repackaged.springframework.beans.factory.support", "org.python.core", "com.bea.core.repackaged.aspectj.weaver.tools.cache", "com.bea.core.repackaged.aspectj.weaver.tools", "com.bea.core.repackaged.aspectj.weaver.reflect", "com.bea.core.repackaged.aspectj.weaver", "com.oracle.wls.shaded.org.apache.xalan.xsltc.trax", "oracle.eclipselink.coherence.integrated.internal.querying", "oracle.eclipselink.coherence.integrated.internal.cache", "javax.swing.plaf.synth", "javax.swing.plaf.metal", "org.hibernate.validator.internal.util.annotation"};
        DEFAULT_ALLOWLIST_CLASSES = new String[0];
        DEFAULT_BLACKLIST_CLASSES = new String[]{"org.codehaus.groovy.runtime.ConvertedClosure", "org.codehaus.groovy.runtime.ConversionHandler", "org.codehaus.groovy.runtime.MethodClosure", "org.springframework.transaction.support.AbstractPlatformTransactionManager", "java.rmi.server.UnicastRemoteObject", "java.rmi.server.RemoteObjectInvocationHandler", "com.bea.core.repackaged.springframework.transaction.support.AbstractPlatformTransactionManager", "java.rmi.server.RemoteObject", "com.tangosol.coherence.rest.util.extractor.MvelExtractor", "java.lang.Runtime", "oracle.eclipselink.coherence.integrated.internal.cache.LockVersionExtractor", "org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor", "org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor", "oracle.jdbc.pool.OraclePooledConnection"};
        DEFAULT_WLS_ONLY_ALLOWLIST_PACKAGES = new String[]{"weblogic.**", "oracle.**", "java.**", "javax.**", "org.omg.**", "com.sun.**", "com.bea.**", "com.tangosol.**"};
        DEFAULT_WLS_ONLY_BLACKLIST_PACKAGES = new String[]{"com.tangosol.internal.util.invoke", "com.tangosol.internal.util.invoke.lambda", "com.tangosol.coherence.rest.util.extractor", "com.tangosol.coherence.rest.util", "com.tangosol.coherence.component.application.console", "com.fasterxml.jackson.databind.introspect", "com.fasterxml.jackson.databind.ser", "weblogic.externals.com.fasterxml.jackson_2_12_0.databind.introspect", "weblogic.externals.com.fasterxml.jackson_2_12_0.databind.ser"};
        DEFAULT_WLS_ONLY_ALLOWLIST_CLASSES = new String[0];
        DEFAULT_WLS_ONLY_BLACKLIST_CLASSES = new String[]{"com.tangosol.util.extractor.ReflectionExtractor", "com.tangosol.util.extractor.ComparisonValueExtractor", "com.tangosol.util.extractor.ConditionalExtractor", "com.tangosol.util.extractor.ReflectionUpdater", "com.tangosol.util.extractor.ScriptValueExtractor", "com.tangosol.util.extractor.UniversalExtractor", "com.tangosol.util.extractor.UniversalUpdater", "com.tangosol.internal.util.SimpleBinaryEntry", "com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage$BinaryEntry", "com.sun.rowset.JdbcRowSetImpl", "java.net.URL"};
        DEFAULT_UNAUTHENTICATED_USER_ALLOWLISTS = new String[]{"weblogic.rmi.**", "weblogic.rjvm.*", "weblogic.common.**", "weblogic.corba.**", "weblogic.cluster.**", "weblogic.ejb20.**", "weblogic.security.acl.internal.*", "weblogic.security.acl.*", "weblogic.security.principal.*", "weblogic.transaction.*", "weblogic.jms.**", "weblogic.messaging.dispatcher.*", "java.util.*", "java.lang.*"};
        DOMAIN_DIR_PATH = "config" + File.separator + "security";
        SHIPHOME_DIR_PATH = "oracle_common" + File.separator + "common" + File.separator + "jep290";
        headSerialFilterPropFilesContent = new LinkedHashMap<String, String>();
        headGlobalSerialFilterPropFilesContent = new LinkedHashMap<String, String>();
        serialFilterPropFilesContent = new LinkedHashMap<String, String>();
        globalSerialFilterPropFilesContent = new LinkedHashMap<String, String>();
        unauthenticatedSerialFilterPropFilesContent = new LinkedHashMap<String, String>();
    }

    static enum ElementType {
        LIMIT,
        CLASS,
        PACKAGE,
        BLOCKLIST,
        ALLOWLIST;

    }

    public static enum FilterViolationAction {
        LOG,
        DENY,
        IGNORE;

    }

    static enum FilterScope {
        GLOBAL,
        WEBLOGIC;

    }

    static enum FilterMode {
        COMBINE,
        REPLACE,
        DISABLE;

    }
}

