/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;

public class WebLogicObjectInputFilterWrapperHelper {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugAllowList");
    public static final int MAX_ARRAY_SIZE = WebLogicObjectInputFilter.getSerialRecordingMaxArraySize();
    private static AtomicInteger globalCount = new AtomicInteger(0);
    private static AtomicInteger serialCount = new AtomicInteger(0);
    private static AtomicReferenceArray serialArray = new AtomicReferenceArray(MAX_ARRAY_SIZE);
    private static AtomicReferenceArray globalArray = new AtomicReferenceArray(MAX_ARRAY_SIZE);
    private static final Object jep290ArrayLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndResetCounters(WebLogicObjectInputFilter.Scope scope, String normalizedName) {
        if (scope == WebLogicObjectInputFilter.Scope.WEBLOGIC) {
            Object object = jep290ArrayLock;
            synchronized (object) {
                WebLogicObjectInputFilter.setSerialListRecordedClasses(WebLogicObjectInputFilterWrapperHelper.copyArrayToList(serialArray, normalizedName));
                serialCount.set(0);
                serialArray = new AtomicReferenceArray(MAX_ARRAY_SIZE);
            }
        }
        if (scope == WebLogicObjectInputFilter.Scope.GLOBAL) {
            Object object = jep290ArrayLock;
            synchronized (object) {
                WebLogicObjectInputFilter.setGlobalListRecordedClasses(WebLogicObjectInputFilterWrapperHelper.copyArrayToList(globalArray, normalizedName));
                globalCount.set(0);
                globalArray = new AtomicReferenceArray(MAX_ARRAY_SIZE);
            }
        }
    }

    private static List copyArrayToList(AtomicReferenceArray array, String normalizedName) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            String arrayStr = (String)array.get(i);
            if (arrayStr == null) continue;
            list.add(arrayStr);
        }
        if (normalizedName != null) {
            list.add(normalizedName);
        }
        return list;
    }

    public static List copySerialArrayToList() {
        List seriaList = WebLogicObjectInputFilterWrapperHelper.copyArrayToList(serialArray);
        return seriaList;
    }

    public static List copyGlobalArrayToList() {
        List globalList = WebLogicObjectInputFilterWrapperHelper.copyArrayToList(globalArray);
        return globalList;
    }

    public static List copyArrayToList(AtomicReferenceArray array) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            String arrayStr = (String)array.get(i);
            if (arrayStr == null) continue;
            list.add(arrayStr);
        }
        return list;
    }

    protected static void recordInputClass(String normalizedName, WebLogicObjectInputFilter.Scope scope) {
        if (scope == WebLogicObjectInputFilter.Scope.WEBLOGIC && normalizedName != null) {
            int idx = serialCount.getAndIncrement();
            if (serialCount.get() >= MAX_ARRAY_SIZE) {
                WebLogicObjectInputFilterWrapperHelper.copyAndResetCounters(WebLogicObjectInputFilter.Scope.WEBLOGIC, normalizedName);
            } else {
                serialArray.set(idx, normalizedName);
            }
        } else if (scope == WebLogicObjectInputFilter.Scope.GLOBAL && normalizedName != null) {
            int gidx = globalCount.getAndIncrement();
            if (globalCount.get() >= MAX_ARRAY_SIZE) {
                WebLogicObjectInputFilterWrapperHelper.copyAndResetCounters(WebLogicObjectInputFilter.Scope.GLOBAL, normalizedName);
            } else {
                globalArray.set(gidx, normalizedName);
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("DESERIALIZED CLASS: " + normalizedName + " SCOPE: " + scope.toString());
        }
    }
}

