/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;

public class WebLogicObjectInputFilterWrapperPerStreamBase {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugDeserializationTimeLimit");
    private final long maxWaitTimeLimitMillis;
    private static int key = 0;
    private final int id = this.getID();
    private long totalTimeMillis = 0L;
    private long resumeTimeMillis = 0L;
    private long suspendTimeMillis = 0L;
    private long totalIdleTimeMillis = 0L;
    private boolean started = false;
    private boolean suspended = false;
    private int suspendCount = 0;
    private boolean timeout = false;

    protected long getMTL() {
        return this.maxWaitTimeLimitMillis;
    }

    private synchronized int getID() {
        return key++;
    }

    public WebLogicObjectInputFilterWrapperPerStreamBase(long value) {
        this.maxWaitTimeLimitMillis = value;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected int getId() {
        return this.id;
    }

    public boolean suspendedNotTimeout() {
        long currentTimeMillis = System.currentTimeMillis();
        ++this.suspendCount;
        if (this.timeout) {
            return !this.timeout;
        }
        if (!this.suspended) {
            if (this.started) {
                this.totalTimeMillis += currentTimeMillis - this.resumeTimeMillis;
            }
            this.suspendTimeMillis = currentTimeMillis;
        }
        this.suspended = true;
        if (this.totalTimeMillis >= this.maxWaitTimeLimitMillis) {
            WebLogicObjectInputFilter.setFilterDeserializationTimeExceeded();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Max time limit check(" + this.id + ") Suspend and Exceeded(Status.REJECTED) suspendCount " + this.suspendCount + " total suspension time:" + this.totalIdleTimeMillis + " and total time spent:" + this.totalTimeMillis + " exceeded max:" + this.maxWaitTimeLimitMillis);
            }
            this.timeout = true;
            return !this.timeout;
        }
        return !this.timeout;
    }

    public boolean isMaxTimeLimitExceeded() {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.timeout) {
            return true;
        }
        if (!this.started) {
            this.totalTimeMillis = 0L;
            this.resumeTimeMillis = currentTimeMillis;
            this.started = true;
            this.suspended = false;
            return false;
        }
        if (this.suspended) {
            this.suspended = false;
            this.resumeTimeMillis = currentTimeMillis;
            long delta = currentTimeMillis - this.suspendTimeMillis;
            this.totalIdleTimeMillis += delta;
            return false;
        }
        long spentTimeMillis = this.totalTimeMillis + currentTimeMillis - this.resumeTimeMillis;
        if (spentTimeMillis >= this.maxWaitTimeLimitMillis) {
            WebLogicObjectInputFilter.setFilterDeserializationTimeExceeded();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Max time limit check(" + this.id + ") checkInput(Status.REJECTED) suspendCount " + this.suspendCount + " total suspension time:" + this.suspendTimeMillis + " and total time spent:" + spentTimeMillis + " exceeded max:" + this.maxWaitTimeLimitMillis);
            }
            this.timeout = true;
            return this.timeout;
        }
        return false;
    }
}

