/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.jars.JarFileUtils2;
import weblogic.utils.jars.VirtualJarFile;

final class JarFileDelegate
implements VirtualJarFile {
    private final JarFile jarFile;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.Debug");

    public JarFileDelegate(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public JarFileDelegate(File file) throws IOException {
        try {
            this.jarFile = JarFileUtils2.openJarFile(file);
        }
        catch (IOException e) {
            IOException reThrow = new IOException(e.getMessage() + " with : " + file.getPath());
            StackTraceElement[] stack = e.getStackTrace();
            reThrow.setStackTrace(stack);
            throw reThrow;
        }
    }

    @Override
    public String getName() {
        return this.jarFile.getName();
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }

    @Override
    public Iterator<ZipEntry> entries() {
        return new Iterator<ZipEntry>(){
            Enumeration<JarEntry> e;
            {
                this.e = JarFileDelegate.this.jarFile.entries();
            }

            @Override
            public ZipEntry next() {
                return this.e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<ZipEntry> getEntries(String uri) {
        if (uri == null) {
            return this.entries();
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        Iterator<ZipEntry> iter = this.entries();
        final String startStr = uri;
        return new FilteringIterator(iter){

            @Override
            public boolean accept(Object o) {
                String name = ((ZipEntry)o).getName();
                return name.startsWith(startStr);
            }
        };
    }

    @Override
    public URL getResource(String name) {
        ZipEntry ze = this.getEntry(name);
        if (ze == null) {
            return null;
        }
        String zipFileName = this.jarFile.getName().replace(File.separatorChar, '/');
        String zipurl = zipFileName + '!' + '/' + ze.getName();
        try {
            return new URL("zip", "", zipurl);
        }
        catch (MalformedURLException mue) {
            try {
                return new URL("jar", "", new File(zipurl).toURL().toString());
            }
            catch (MalformedURLException muee) {
                return null;
            }
        }
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.jarFile.getEntry(name);
    }

    @Override
    public InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.jarFile.getInputStream(ze);
    }

    @Override
    public Manifest getManifest() throws IOException {
        try {
            return this.jarFile.getManifest();
        }
        catch (IOException ioe) {
            LOGGER.warning("' " + ioe + " ' occurred while reading MANIFEST.MF of archived file " + this.jarFile.getName() + ", please check restrictions and rules that apply to manifest files");
            throw ioe;
        }
    }

    @Override
    public File[] getRootFiles() {
        return new File[]{new File(this.jarFile.getName())};
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public File getDirectory() {
        return null;
    }

    @Override
    public JarFile getJarFile() {
        return this.jarFile;
    }

    public String toString() {
        return super.toString() + " - " + this.getName();
    }
}

