/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import weblogic.utils.Debug;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.jars.Manifest;
import weblogic.utils.jars.ManifestEntry;

public final class JarFileObject {
    private static final boolean ASSERT = false;
    private static final boolean VERBOSE = false;
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private Manifest manifest;
    private File location;

    public JarFileObject(File location, Manifest manifest) {
        this(location);
        this.setManifest(manifest);
    }

    public JarFileObject(File location) {
        this.setLocation(location);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public File getLocation() {
        return this.location;
    }

    private void setLocation(File location) {
        this.location = location;
    }

    public void extract(File root) throws IOException {
        this.extract(root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(File root, String filter) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.location));
        String rootPath = root.getPath();
        try (ZipInputStream zip = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                if (filter != null && !entry.getName().startsWith(filter)) continue;
                String path = entry.getName().replace('/', File.separatorChar);
                path = rootPath + File.separator + path;
                File file = new File(path);
                String leaf = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                String dir = path.substring(0, path.lastIndexOf(File.separatorChar));
                if (leaf != null && !leaf.equals("")) {
                    OutputStream out = null;
                    File parent = new File(dir);
                    if (!(parent.exists() && parent.isDirectory() || parent.mkdirs())) {
                        throw new IOException("Couldn't make directory for " + dir);
                    }
                    try {
                        boolean deleted;
                        if (file.exists() && !(deleted = file.delete())) {
                            throw new IOException("Unable to overwrite file: " + file.getAbsolutePath());
                        }
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        StreamUtils.writeTo(zip, out);
                        continue;
                    }
                    finally {
                        zip.closeEntry();
                        if (out == null) continue;
                        out.close();
                        continue;
                    }
                }
                if (dir == null || dir.length() <= 0) continue;
                try {
                    File subDir = new File(dir);
                    subDir.mkdirs();
                }
                finally {
                    zip.closeEntry();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.location == null) {
            throw new NullPointerException("location not set");
        }
        BufferedOutputStream o = new BufferedOutputStream(new FileOutputStream(this.location));
        try (ZipOutputStream zip = null;){
            zip = new ZipOutputStream(o);
            zip.setLevel(9);
            ZipEntry entry = new ZipEntry(MANIFEST_ENTRY);
            entry.setMethod(8);
            zip.putNextEntry(entry);
            this.manifest.stream(zip);
            zip.closeEntry();
            for (ManifestEntry manifestEntry : this.manifest.getEntries().values()) {
                InputStream in = null;
                try {
                    File f = manifestEntry.getFile();
                    if (f != null && f.getName().equals("MANIFEST.MF")) continue;
                    in = new FileInputStream(f);
                    entry = new ZipEntry(manifestEntry.getName());
                    zip.putNextEntry(entry);
                    StreamUtils.writeTo(in, zip);
                    zip.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            zip.flush();
        }
    }

    private static void info(String info) {
        System.out.println("<JarTool> " + info);
    }

    private static void checkDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new IOException("Input Directory " + directory.getAbsolutePath() + " does not exist.");
        }
        if (!directory.canRead()) {
            throw new IOException("Input Directory " + directory.getAbsolutePath() + " can not be read.");
        }
    }

    private static void addFilesToManifest(Manifest manifest, File root, File dir) {
        String[] fileNames = dir.list();
        String path = dir.getAbsolutePath();
        for (int i = 0; i < fileNames.length; ++i) {
            File f = new File(path + File.separator + fileNames[i]);
            if (f.isDirectory()) {
                JarFileObject.addFilesToManifest(manifest, root, f);
                continue;
            }
            ManifestEntry entry = new ManifestEntry(root, f);
            manifest.addEntry(entry);
        }
    }

    public static JarFileObject makeJar(String jarPath, File directory) throws IOException {
        Debug.assertion(directory != null);
        JarFileObject.checkDirectory(directory);
        File jarFile = new File(jarPath);
        Manifest mft = new Manifest();
        String mPath = directory + File.separator + MANIFEST_ENTRY;
        File mFile = new File(mPath);
        if (mFile.exists()) {
            String mftCP;
            FileInputStream mFilein = new FileInputStream(mFile);
            java.util.jar.Manifest m = new java.util.jar.Manifest(mFilein);
            mFilein.close();
            Attributes mAttributes = m.getMainAttributes();
            if (mAttributes != null && (mftCP = (String)mAttributes.get(Attributes.Name.CLASS_PATH)) != null) {
                mft.getHeaders().addHeader(Attributes.Name.CLASS_PATH.toString(), mftCP);
            }
        }
        JarFileObject.addFilesToManifest(mft, directory, directory);
        return new JarFileObject(jarFile, mft);
    }
}

