/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarFileUtils2 {
    private static final Constructor<?> jarFileConstructor;
    private static final Integer modeArg;
    private static Comparable<?> baseVersion;
    private static Comparable<?> runtimeVersion;
    private static Method parseMethod;
    private static Method getRealNameMethod;

    public static JarFile openJarFile(String file) throws IOException {
        return JarFileUtils2.openJarFile(new File(file), Boolean.TRUE, runtimeVersion);
    }

    public static JarFile openJarFile(String file, boolean verifyArg) throws IOException {
        return JarFileUtils2.openJarFile(new File(file), verifyArg, runtimeVersion);
    }

    public static JarFile openJarFile(File file) throws IOException {
        return JarFileUtils2.openJarFile(file, Boolean.TRUE, runtimeVersion);
    }

    public static JarFile openJarFile(File file, boolean verifyArg) throws IOException {
        return JarFileUtils2.openJarFile(file, verifyArg, runtimeVersion);
    }

    public static JarFile openJarFile(File file, boolean verifyArg, Comparable version) throws IOException {
        if (jarFileConstructor != null) {
            try {
                return (JarFile)jarFileConstructor.newInstance(file, verifyArg, modeArg, version);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return new JarFile(file);
    }

    public static Comparable<?> getBaseVersion() {
        return baseVersion;
    }

    public static Comparable<?> getRuntimeVersion() {
        return runtimeVersion;
    }

    public static Method getParseMethod() {
        return parseMethod;
    }

    public static String getRealName(JarEntry j) {
        if (getRealNameMethod == null) {
            return j.getName();
        }
        try {
            return (String)getRealNameMethod.invoke((Object)j, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        modeArg = 1;
        parseMethod = null;
        getRealNameMethod = null;
        Method baseVersionMethod = null;
        try {
            baseVersionMethod = JarFile.class.getMethod("baseVersion", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            getRealNameMethod = JarEntry.class.getMethod("getRealName", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object bv = null;
        if (baseVersionMethod != null) {
            try {
                bv = baseVersionMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        baseVersion = bv != null ? (Comparable)bv : Integer.valueOf(8);
        Method runtimeVersionMethod = null;
        try {
            runtimeVersionMethod = JarFile.class.getMethod("runtimeVersion", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object rv = null;
        if (runtimeVersionMethod != null) {
            try {
                rv = runtimeVersionMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        runtimeVersion = rv != null ? (Comparable)rv : baseVersion;
        Constructor c = null;
        if (rv != null) {
            try {
                c = JarFile.class.getConstructor(File.class, Boolean.TYPE, Integer.TYPE, rv.getClass());
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        jarFileConstructor = c;
        if (runtimeVersionMethod != null) {
            try {
                parseMethod = runtimeVersionMethod.getReturnType().getMethod("parse", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

