/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class ManifestEntry {
    private static char SPACE = (char)32;
    private static String NEWLINE = System.getProperty("line.separator");
    private static byte[] NEWLINE_BYTES = NEWLINE.getBytes();
    private File root;
    private File file;
    private String name;
    private final ArrayMap attributes = new ArrayMap();
    private final ArrayList keys = new ArrayList();

    ManifestEntry() {
    }

    public ManifestEntry(File root, File file) {
        if (root == null) {
            root = new File("/");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("bad file: is a directory: " + file);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("bad root: not a directory: " + root);
        }
        this.file = file;
        this.root = root;
    }

    public ManifestEntry(File file, File root, Map attributes) {
        this(file, root);
        for (String key : attributes.values()) {
            this.addHeader(key, (String)attributes.get(key));
        }
    }

    public Iterator getHeaders() {
        return this.keys.iterator();
    }

    public void addHeader(String key, String value) {
        String lcKey = key.toLowerCase();
        if (this.attributes.containsKey(lcKey)) {
            this.removeFromKeys(key);
        }
        this.keys.add(key);
        this.attributes.put(lcKey, value);
    }

    public String getHeader(String key) {
        return (String)this.attributes.get(key.toLowerCase());
    }

    public boolean removeHeader(String key) {
        return this.removeFromKeys(key) && this.attributes.remove(this.getHeader(key)) != null;
    }

    private boolean removeFromKeys(String key) {
        for (String existingKey : this.keys) {
            if (!existingKey.equalsIgnoreCase(key)) continue;
            this.keys.remove(existingKey);
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        block4: {
            String rootPath = null;
            try {
                if (this.name != null) break block4;
                if (this.root != null) {
                    rootPath = this.root.getCanonicalPath();
                    String path = this.file.getCanonicalPath();
                    this.name = path.substring(rootPath.length() + 1);
                    this.name = this.name.replace(File.separatorChar, '/');
                    break block4;
                }
                return this.getHeader("Name");
            }
            catch (IOException e) {
                File problemF = this.file;
                if (rootPath == null) {
                    problemF = this.root;
                }
                throw new InternalError("IO error while trying to compute name from: " + problemF + "\t" + e);
            }
        }
        return this.name;
    }

    public boolean stream(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        String line;
        while ((line = din.readLine()) != null) {
            if (line.length() == 0) {
                return true;
            }
            int sepCharPos = line.indexOf(58);
            if (sepCharPos <= 0) continue;
            String key = line.substring(0, sepCharPos);
            String value = line.substring(sepCharPos + 2, line.length());
            this.addHeader(key, value);
        }
        return false;
    }

    public void stream(OutputStream out) throws IOException {
        if (this.name != null) {
            String header = "Name: " + this.name;
            out.write(header.getBytes(), 0, header.length());
            out.write(NEWLINE_BYTES);
        }
        int count = this.keys.size();
        for (String key : this.keys) {
            String value = this.getHeader(key);
            this.breakUpAndWriteItOutAsNecessary(key, value, out);
            if (count-- == 0) continue;
            out.write(NEWLINE_BYTES);
        }
    }

    private void breakUpAndWriteItOutAsNecessary(String key, String value, OutputStream out) throws IOException {
        int valueLen = value.length();
        String header = key + ": ";
        int headerLen = header.length();
        int excess = headerLen + valueLen - 72;
        if (excess <= 0) {
            header = header + value;
            out.write(header.getBytes(), 0, header.length());
            return;
        }
        int index = 72 - headerLen;
        int spacesToAdd = excess / 72;
        boolean prependSpace = false;
        if (excess % 72 > 0) {
            ++spacesToAdd;
        }
        for (int i = 0; i <= spacesToAdd; ++i) {
            if (prependSpace) {
                out.write(SPACE);
                if (valueLen > 71) {
                    out.write(value.getBytes(), index, 71);
                    valueLen -= 71;
                    index += 71;
                    out.write(NEWLINE_BYTES);
                    continue;
                }
                out.write(value.getBytes(), index, valueLen);
                continue;
            }
            prependSpace = true;
            out.write(header.getBytes());
            out.write(value.getBytes(), 0, index);
            valueLen -= index;
            out.write(NEWLINE_BYTES);
        }
    }

    public String toString() {
        try {
            UnsyncByteArrayOutputStream out = new UnsyncByteArrayOutputStream();
            this.stream(out);
            return new String(out.toByteArray());
        }
        catch (IOException e) {
            return "error trying to print manifest entry " + e;
        }
    }
}

