/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import weblogic.utils.jars.BaseExplodedJarFile;

final class SplitExplodedJarFile
extends BaseExplodedJarFile {
    private final File[] dirs;

    public SplitExplodedJarFile(File[] dirs) {
        this.dirs = dirs;
    }

    public SplitExplodedJarFile(File srcDir, File outDir) {
        this.dirs = new File[]{srcDir, outDir};
    }

    @Override
    public String getName() {
        return this.dirs[0].toString();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<ZipEntry> entries() {
        return this.getEntries("/");
    }

    @Override
    public Iterator<ZipEntry> getEntries(String uri) {
        if (uri == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        HashSet<ZipEntry> entries = new HashSet<ZipEntry>();
        String fileUri = uri.replace('/', File.separatorChar);
        for (int i = 0; i < this.dirs.length; ++i) {
            if (!this.dirs[i].exists()) continue;
            this.addEntries(entries, new File(this.dirs[i], fileUri), this.dirs[i]);
        }
        return entries.iterator();
    }

    private void addEntries(Set<ZipEntry> entries, File dir, File parent) {
        File[] files = dir.listFiles();
        int parentLen = parent.toString().length();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String name;
            if (files[i].isDirectory()) {
                this.addEntries(entries, files[i], parent);
                continue;
            }
            name = name.substring(parentLen + (parentLen == (name = files[i].toString()).length() ? 0 : 1)).replace(File.separatorChar, '/');
            entries.add(new BaseExplodedJarFile.VirtualJarEntry(parent, name));
        }
    }

    @Override
    public ZipEntry getEntry(String name) {
        for (int i = 0; i < this.dirs.length; ++i) {
            ZipEntry ze = this.getEntry(this.dirs[i], name);
            if (ze == null) continue;
            return ze;
        }
        return null;
    }

    @Override
    public File[] getRootFiles() {
        return this.dirs;
    }

    @Override
    public File getDirectory() {
        return this.dirs[0];
    }

    public String toString() {
        StringBuffer result = new StringBuffer("SplitExplodedJarFile{");
        if (this.dirs == null) {
            result.append("null");
        } else {
            for (int i = 0; i < this.dirs.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(this.dirs[i].toString());
            }
        }
        result.append("}");
        return result.toString();
    }
}

