/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class Interceptor
implements InvocationHandler {
    Object delegate;

    public static Object intercept(Object o) {
        Interceptor interceptor = new Interceptor(o);
        return Proxy.newProxyInstance(o.getClass().getClassLoader(), o.getClass().getInterfaces(), (InvocationHandler)interceptor);
    }

    private Interceptor(Object o) {
        this.delegate = o;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuffer sb = new StringBuffer(200);
        sb.append(method.getName()).append("(");
        Interceptor.stringify(sb, args);
        sb.append(")");
        try {
            Object retval = method.invoke(this.delegate, args);
            if (retval != null) {
                sb.append(" ---> ");
                Interceptor.stringify(sb, retval);
            }
            Object object = retval;
            return object;
        }
        catch (Throwable t) {
            sb.append(" ---> ");
            sb.append(t.toString());
            throw t;
        }
        finally {
            System.out.println(sb);
        }
    }

    public static void stringify(StringBuffer sb, Object arg) {
        if (arg == null) {
            return;
        }
        Class<?> clazz = arg.getClass();
        if (clazz.isArray()) {
            sb.append("[");
            if (clazz.getComponentType().isPrimitive()) {
                if ((clazz = clazz.getComponentType()).equals(Boolean.TYPE)) {
                    Interceptor.stringify(sb, (boolean[])arg);
                } else if (clazz.equals(Byte.TYPE)) {
                    Interceptor.stringify(sb, (byte[])arg);
                } else if (clazz.equals(Character.TYPE)) {
                    Interceptor.stringify(sb, (char[])arg);
                } else if (clazz.equals(Short.TYPE)) {
                    Interceptor.stringify(sb, (short[])arg);
                } else if (clazz.equals(Integer.TYPE)) {
                    Interceptor.stringify(sb, (int[])arg);
                } else if (clazz.equals(Long.TYPE)) {
                    Interceptor.stringify(sb, (long[])arg);
                } else if (clazz.equals(Float.TYPE)) {
                    Interceptor.stringify(sb, (float[])arg);
                } else if (clazz.equals(Double.TYPE)) {
                    Interceptor.stringify(sb, (double[])arg);
                } else {
                    sb.append(arg);
                }
            } else {
                Interceptor.stringify(sb, (Object[])arg);
            }
            sb.append("]");
        } else {
            sb.append(arg.toString());
        }
    }

    public static void stringify(StringBuffer sb, Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Interceptor.stringify(sb, args[i]);
        }
    }

    public static void stringify(StringBuffer sb, boolean[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, byte[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, char[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, short[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, int[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, long[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, float[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }

    public static void stringify(StringBuffer sb, double[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args[i]);
        }
    }
}

