/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import weblogic.utils.collections.StackPool;

public class MethodSignatureBuilder {
    public static boolean ignoreGenerics = false;
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    public static String compute(Method m) {
        Class<?>[] parameters;
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append('(');
        for (Class<?> cl : parameters = m.getParameterTypes()) {
            while (cl.isArray()) {
                sb.append('[');
                cl = cl.getComponentType();
            }
            MethodSignatureBuilder.encode(cl.getName(), sb);
        }
        sb.append(')');
        return sb.toString().intern();
    }

    private static void encode(String typeName, StringBuilder buf) {
        String ret = typeMap.get(typeName);
        if (ret == null) {
            buf.append("L").append(typeName).append(';');
        } else {
            buf.append(ret);
        }
    }

    public static String compute(String s) {
        if ("*".equals(s)) {
            return s;
        }
        Parser parser = Parser.getInstance();
        parser.initialize(s);
        try {
            String string = parser.parse();
            return string;
        }
        finally {
            Parser.releaseInstance(parser);
        }
    }

    static {
        typeMap.put(Byte.TYPE.getName(), "B");
        typeMap.put(Character.TYPE.getName(), "C");
        typeMap.put(Double.TYPE.getName(), "D");
        typeMap.put(Float.TYPE.getName(), "F");
        typeMap.put(Integer.TYPE.getName(), "I");
        typeMap.put(Long.TYPE.getName(), "J");
        typeMap.put(Short.TYPE.getName(), "S");
        typeMap.put(Boolean.TYPE.getName(), "Z");
    }

    private static final class Parser {
        private static final StackPool parserPool = new StackPool(5);
        private static final Object poolLock = new Object();
        private int pos = 0;
        private int strLen = 0;
        private CharSequence cs;
        private StringBuilder sb = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Parser getInstance() {
            Parser p;
            Object object = poolLock;
            synchronized (object) {
                p = (Parser)parserPool.remove();
            }
            if (p == null) {
                p = new Parser();
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void releaseInstance(Parser parser) {
            parser.reset();
            Object object = poolLock;
            synchronized (object) {
                parserPool.add(parser);
            }
        }

        private Parser() {
        }

        private void initialize(CharSequence s) {
            this.cs = s;
            this.strLen = this.cs.length();
        }

        private void reset() {
            this.sb.delete(0, this.sb.length());
            this.pos = 0;
            this.strLen = 0;
            this.cs = null;
        }

        private String parse() {
            this.method();
            if (!this.available()) {
                this.sb.append("()");
            } else {
                this.parameterBegin();
                this.buildArgumentList();
                this.parameterEnd();
            }
            return this.sb.toString();
        }

        private void method() {
            this.consumeSpaces();
            int methodBegin = this.pos;
            while (!(!this.available() || this.isOpenBracket() || this.isSpaceTab() || this.isSquareBracketBegin() || this.isSquareBracketEnd())) {
                this.incPos(1);
            }
            this.sb.append(this.cs, methodBegin, this.pos);
            this.consumeSpaces();
        }

        private void parameterBegin() {
            if (!this.isOpenBracket()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
            }
            this.incPos(1);
            this.sb.append('(');
        }

        private void parameterEnd() {
            if (!this.isCloseBracket()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
            }
            this.sb.append(')');
        }

        private void buildArgumentList() {
            while (true) {
                this.consumeSpaces();
                int typeStartPos = this.pos;
                while (!(!this.available() || this.isComma() || this.isCloseBracket() || this.isSpace() || this.isSquareBracketBegin())) {
                    if (this.isLessThan()) {
                        throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
                    }
                    if (this.isGreaterThan()) {
                        throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
                    }
                    this.incPos(1);
                }
                if (typeStartPos == this.pos) break;
                int typeEndPos = this.pos;
                this.handleArrays();
                this.typeStart(typeStartPos, typeEndPos);
                this.typeEnd();
            }
        }

        private void handleArrays() {
            this.consumeSpaces();
            while (this.available() && !this.isComma() && !this.isCloseBracket()) {
                if (this.isSquareBracketBegin()) {
                    this.incPos(1);
                    if (this.available() && this.isSquareBracketEnd()) {
                        this.incPos(1);
                        this.sb.append('[');
                        this.consumeSpaces();
                        continue;
                    }
                }
                throw new IllegalArgumentException("Couldn't parse '" + this.cs.toString() + "'. Found '" + this.cs.charAt(this.pos) + "' at position " + this.pos);
            }
        }

        private void typeStart(int startPos, int endPos) {
            switch (endPos - startPos) {
                case 3: {
                    if (this.cs.charAt(startPos) == 'i' && this.cs.charAt(startPos + 1) == 'n' && this.cs.charAt(startPos + 2) == 't') {
                        this.sb.append('I');
                        break;
                    }
                    this.sb.append('L').append(this.cs, startPos, endPos).append(';');
                    break;
                }
                case 4: {
                    if (this.cs.charAt(startPos) == 'b' && this.cs.charAt(startPos + 1) == 'y' && this.cs.charAt(startPos + 2) == 't' && this.cs.charAt(startPos + 3) == 'e') {
                        this.sb.append('B');
                        break;
                    }
                    if (this.cs.charAt(startPos) == 'c' && this.cs.charAt(startPos + 1) == 'h' && this.cs.charAt(startPos + 2) == 'a' && this.cs.charAt(startPos + 3) == 'r') {
                        this.sb.append('C');
                        break;
                    }
                    if (this.cs.charAt(startPos) == 'l' && this.cs.charAt(startPos + 1) == 'o' && this.cs.charAt(startPos + 2) == 'n' && this.cs.charAt(startPos + 3) == 'g') {
                        this.sb.append('J');
                        break;
                    }
                    this.sb.append('L').append(this.cs, startPos, endPos).append(';');
                    break;
                }
                case 5: {
                    if (this.cs.charAt(startPos) == 'f' && this.cs.charAt(startPos + 1) == 'l' && this.cs.charAt(startPos + 2) == 'o' && this.cs.charAt(startPos + 3) == 'a' && this.cs.charAt(startPos + 4) == 't') {
                        this.sb.append('F');
                        break;
                    }
                    if (this.cs.charAt(startPos) == 's' && this.cs.charAt(startPos + 1) == 'h' && this.cs.charAt(startPos + 2) == 'o' && this.cs.charAt(startPos + 3) == 'r' && this.cs.charAt(startPos + 4) == 't') {
                        this.sb.append('S');
                        break;
                    }
                    this.sb.append('L').append(this.cs, startPos, endPos).append(';');
                    break;
                }
                case 6: {
                    if (this.cs.charAt(startPos) == 'd' && this.cs.charAt(startPos + 1) == 'o' && this.cs.charAt(startPos + 2) == 'u' && this.cs.charAt(startPos + 3) == 'b' && this.cs.charAt(startPos + 4) == 'l' && this.cs.charAt(startPos + 5) == 'e') {
                        this.sb.append('D');
                        break;
                    }
                    this.sb.append('L').append(this.cs, startPos, endPos).append(';');
                    break;
                }
                case 7: {
                    if (this.cs.charAt(startPos) == 'b' && this.cs.charAt(startPos + 1) == 'o' && this.cs.charAt(startPos + 2) == 'o' && this.cs.charAt(startPos + 3) == 'l' && this.cs.charAt(startPos + 4) == 'e' && this.cs.charAt(startPos + 5) == 'a' && this.cs.charAt(startPos + 6) == 'n') {
                        this.sb.append('Z');
                        break;
                    }
                }
                default: {
                    this.sb.append('L').append(this.cs, startPos, endPos).append(';');
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void typeEnd() {
            if (!this.available()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
            }
            if (this.isSpaceTab()) {
                this.consumeSpaces();
                if (!this.available()) throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
                if (!this.isComma()) return;
                this.incPos(1);
                return;
            } else if (this.isComma()) {
                this.incPos(1);
                return;
            } else {
                if (this.isCloseBracket()) return;
                throw new IllegalArgumentException("Method Parsing failed for '" + this.cs.toString() + "' at position " + this.pos);
            }
        }

        private boolean isOpenBracket() {
            return this.cs.charAt(this.pos) == '(';
        }

        private boolean isCloseBracket() {
            return this.cs.charAt(this.pos) == ')';
        }

        private boolean isLessThan() {
            return this.cs.charAt(this.pos) == '<';
        }

        private boolean isGreaterThan() {
            return this.cs.charAt(this.pos) == '>';
        }

        private boolean isSquareBracketBegin() {
            return this.cs.charAt(this.pos) == '[';
        }

        private boolean isSquareBracketEnd() {
            return this.cs.charAt(this.pos) == ']';
        }

        private boolean isComma() {
            return this.cs.charAt(this.pos) == ',';
        }

        private boolean isSpaceTab(char b) {
            return b == ' ' || b == '\t';
        }

        private boolean isSpace() {
            return this.isSpaceTab();
        }

        private boolean isSpaceTab() {
            return this.isSpaceTab(this.cs.charAt(this.pos));
        }

        private int incPos(int count) {
            this.pos += count;
            return this.pos;
        }

        private void consumeSpaces() {
            while (this.available() && this.isSpaceTab()) {
                this.incPos(1);
            }
        }

        private boolean available() {
            return this.strLen > this.pos;
        }
    }
}

