/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import weblogic.utils.string.CachingDateFormat;

public class SimpleCachingDateFormat
extends CachingDateFormat {
    private final Date d = new Date();
    private final SimpleDateFormat simpleDateFormat;

    public SimpleCachingDateFormat(String pattern) {
        this(pattern, TimeZone.getDefault());
    }

    public SimpleCachingDateFormat(String pattern, TimeZone tz) {
        this(pattern, tz, Locale.getDefault());
    }

    public SimpleCachingDateFormat(String pattern, TimeZone tz, Locale locale) {
        this.d.setYear(this.d.getYear());
        this.simpleDateFormat = new SimpleDateFormat(pattern, locale);
        this.simpleDateFormat.setTimeZone(tz);
        if (pattern.indexOf(83) != -1) {
            throw new IllegalArgumentException("Cannot cache dates with millisecond resolution");
        }
        this.resolution = pattern.indexOf(115) != -1 ? 1000 : (pattern.indexOf(109) != -1 ? 60000 : 360000);
    }

    @Override
    protected String format(long utc) {
        this.d.setTime(utc);
        return this.simpleDateFormat.format(this.d);
    }
}

